/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.client;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.EnumRemotingType;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.RequestWrapperOfFuture;
import com.taobao.hsf.remoting.client.SendCallBackListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class AbstractClient
implements Client {
    private final RemotingURL url;
    private final EnumRemotingType serverType;
    protected volatile boolean enable = true;

    public AbstractClient(RemotingURL url) {
        this.url = url;
        this.serverType = url.getServerType();
    }

    @Override
    public HSFResponse syncInvoke(HSFRequest request, byte codecType, int timeout) throws Exception {
        BaseRequest requestObject = this.serverType.convertRequest(request, codecType, timeout, this);
        RequestWrapperOfFuture future = RequestWrapperOfFuture.create(requestObject);
        this.sendRequest(requestObject, future);
        return future.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<Object> futureInvoke(HSFRequest request, byte codecType, int timeout) throws Exception {
        BaseRequest requestObject = this.serverType.convertRequest(request, codecType, timeout, this);
        RequestWrapperOfFuture future = RequestWrapperOfFuture.create(requestObject);
        this.sendRequest(requestObject, future);
        return future;
    }

    @Override
    public void invokeWithCallBack(HSFRequest request, byte codecType, SendCallBackListener listener) throws Exception {
        this.invokeWithCallBack(request, listener, 1000, codecType);
    }

    @Override
    public void invokeWithCallBack(HSFRequest bridgeRequest, SendCallBackListener listener, int timeout, byte codecType) throws Exception {
        BaseRequest request = this.serverType.convertRequest(bridgeRequest, codecType, timeout, this);
        this.sendRequest(request, listener);
    }

    @Override
    public void invokeWithCallBack(BaseRequest request, SendCallBackListener listener) throws Exception {
        this.sendRequest(request, listener);
    }

    @Override
    public void close(String cause) {
        this.doClose(cause);
    }

    @Override
    public RemotingURL getUrl() {
        return this.url;
    }

    @Override
    public EnumRemotingType getServerType() {
        return this.serverType;
    }

    @Override
    public void disableOut() {
        this.enable = false;
    }

    public abstract void sendRequest(BaseRequest var1, RequestWrapperOfFuture var2) throws Exception;

    public abstract void sendRequest(BaseRequest var1, SendCallBackListener var2) throws Exception;

    protected abstract void doClose(String var1);

    @Override
    public abstract String toString();
}

