/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.exception;

import com.taobao.hsf.remoting.exception.ErrorCode;
import com.taobao.hsf.remoting.exception.ErrorCodeFactory;

public class RemotingCheckedException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ErrorCode errorCode;
    private final Object[] args;

    public RemotingCheckedException(ErrorCode errorCode, Throwable e, Object ... args) {
        super(e);
        this.errorCode = errorCode;
        this.args = args;
    }

    public RemotingCheckedException(ErrorCode errorCode, Object ... args) {
        this(errorCode, null, args);
    }

    public RemotingCheckedException(int errorCode, Throwable e, Object ... args) {
        this(ErrorCodeFactory.getInstance().getErrorCode(errorCode), e, args);
    }

    public RemotingCheckedException(int errorCode, Object ... args) {
        this(ErrorCodeFactory.getInstance().getErrorCode(errorCode), null, args);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.getFormattedMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getFormattedMessage();
    }

    public String getFormattedMessage() {
        return this.errorCode.getFormattedMessage(this.args);
    }
}

