/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.client;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.AbstractClientFactory;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.InvalidCallBackScanTask;
import com.taobao.hsf.remoting.client.ScanTask;
import com.taobao.hsf.remoting.exception.RemotingCheckedException;
import com.taobao.hsf.remoting.exception.RemotingUncheckedException;
import com.taobao.hsf.remoting.netty.NettySharedHolder;
import com.taobao.hsf.remoting.netty.client.NettyClienChannelInitializer;
import com.taobao.hsf.remoting.netty.client.NettyClient;
import com.taobao.hsf.remoting.netty.client.NettyClientHandler;
import com.taobao.hsf.remoting.netty.client.ScanAllClientRunnerClientSide;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class NettyClientFactory
extends AbstractClientFactory {
    private static NettyClientFactory instance = new NettyClientFactory();
    private final Timer timer = NettySharedHolder.timer;
    private final Map<Channel, Client> channel2Client = new ConcurrentHashMap<Channel, Client>();

    private NettyClientFactory() {
        this.timer.newTimeout((TimerTask)new ScanAllClientRunnerClientSide(this, this.getScanTasks()), 60L, TimeUnit.SECONDS);
    }

    public static NettyClientFactory getInstance() {
        return instance;
    }

    protected ScanTask[] getScanTasks() {
        return new ScanTask[]{new InvalidCallBackScanTask()};
    }

    public List<Channel> getAllChannels() {
        return new ArrayList<Channel>(this.channel2Client.keySet());
    }

    @Override
    protected Client createClient(RemotingURL url) throws RemotingCheckedException {
        Bootstrap bootstrap = new Bootstrap();
        NettyClientHandler handler = new NettyClientHandler(this);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)NettySharedHolder.workerGroup)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)NettySharedHolder.byteBufAllocator)).channel(NioSocketChannel.class)).handler((ChannelHandler)new NettyClienChannelInitializer((ChannelHandler)handler));
        int connectTimeout = url.getParameter("_CONNECTTIMEOUT", 4000);
        if (connectTimeout < 1000) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4000);
        } else {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        }
        String targetIP = url.getHost();
        int targetPort = url.getPort();
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(targetIP, targetPort));
        if (future.awaitUninterruptibly((long)connectTimeout) && future.isSuccess() && future.channel().isActive()) {
            Channel channel = future.channel();
            NettyClient client = new NettyClient(url, channel);
            this.channel2Client.put(channel, client);
            return client;
        }
        future.cancel(true);
        future.channel().close();
        LoggerInit.LOGGER.warn("[remoting] failure to connect:" + targetIP);
        throw new RemotingUncheckedException(113, targetIP, targetPort + "", connectTimeout + "");
    }

    public Client getCientByChannel(Channel channel) {
        return this.channel2Client.get(channel);
    }

    public void remove(Channel channel) {
        Client client = this.channel2Client.remove(channel);
        if (client != null) {
            super.remove(client);
        }
    }
}

