/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.encoder;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;

public class NettyByteBufferWrapper
implements ByteBufferWrapper {
    private static final String WRITE_RESPONSE_ERROR = "server write response error,request id is: ";
    private final ByteBuf buffer;
    private final Channel channel;

    public NettyByteBufferWrapper(ByteBuf buffer) {
        this(buffer, null);
    }

    public NettyByteBufferWrapper(ByteBuf buffer, Channel channel) {
        this.channel = channel;
        this.buffer = buffer;
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public void setReaderIndex(int index) {
        this.buffer.setIndex(index, this.buffer.writerIndex());
    }

    @Override
    public void writeByte(byte data) {
        this.buffer.writeByte((int)data);
    }

    @Override
    public void writeBytes(byte[] data) {
        this.buffer.writeBytes(data);
    }

    @Override
    public void writeInt(int data) {
        this.buffer.writeInt(data);
    }

    @Override
    public void writeByte(int index, byte data) {
        this.buffer.writeByte((int)data);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public void send(final BaseResponse object) {
        ChannelFuture wf = this.channel.writeAndFlush((Object)object);
        wf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    LoggerInit.LOGGER.error("", "##########server write response error,request id is: " + object.getRequestID());
                }
            }
        });
    }

    @Override
    public void ensureCapacity(int capacity) {
        this.buffer.capacity(capacity);
    }
}

