/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.encoder;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.ProtocolFactory;
import com.taobao.hsf.remoting.netty.encoder.NettyByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.Protocol;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class NettyProtocolDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        NettyByteBufferWrapper wrapper = new NettyByteBufferWrapper(in, ctx.channel());
        Object msg = this.decode(wrapper);
        if (msg != null) {
            out.add(msg);
        }
    }

    private Object decode(ByteBufferWrapper wrapper) throws Exception {
        int originPos = wrapper.readerIndex();
        if (wrapper.readableBytes() < 1) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte type = wrapper.readByte();
        Protocol protocol = ProtocolFactory.instance.getProtocol(type);
        if (protocol == null) {
            LoggerInit.LOGGER.warn("Unsupport protocol type: " + type);
            return null;
        }
        return protocol.decode(wrapper, originPos);
    }
}

