/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.server;

import com.taobao.hsf.NamedThreadFactory;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.ProtocolFactory;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.RpcResponse;
import com.taobao.hsf.remoting.netty.NettySharedHolder;
import com.taobao.hsf.remoting.netty.encoder.NettyProtocolDecoder;
import com.taobao.hsf.remoting.netty.encoder.NettyProtocolEncoder;
import com.taobao.hsf.remoting.netty.server.NettyServerHandler;
import com.taobao.hsf.remoting.netty.server.NettyServerHttpHandler;
import com.taobao.hsf.remoting.netty.server.ScanAllClientRunnerServerSide;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.Server;
import com.taobao.middleware.logger.Logger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.TimerTask;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NettyServer
implements Server {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("HSF-BOSS"));
    private final EventLoopGroup workerGroup = NettySharedHolder.workerGroup;
    private final NettyServerHandler serverHandler = new NettyServerHandler();
    private final RpcRequestProcessor rpcProcessor;
    private final AtomicBoolean startFlag = new AtomicBoolean(false);
    private final AtomicBoolean startHttpFlag = new AtomicBoolean(false);
    private final String bindHost;

    public NettyServer(RpcRequestProcessor rpcProcessor, String bindHost) {
        this.rpcProcessor = rpcProcessor;
        ProtocolFactory.instance.initServerSide(rpcProcessor);
        this.bindHost = bindHost;
        NettySharedHolder.timer.newTimeout((TimerTask)new ScanAllClientRunnerServerSide(this.serverHandler), 59L, TimeUnit.SECONDS);
    }

    @Override
    public void start(int listenPort) throws Exception {
        if (!this.startFlag.compareAndSet(false, true)) {
            return;
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.ALLOCATOR, (Object)NettySharedHolder.byteBufAllocator)).childOption(ChannelOption.ALLOCATOR, (Object)NettySharedHolder.byteBufAllocator).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("decoder", (ChannelHandler)new NettyProtocolDecoder()).addLast("encoder", (ChannelHandler)new NettyProtocolEncoder()).addLast("handler", (ChannelHandler)NettyServer.this.serverHandler);
            }
        });
        long tryBind = 3L;
        while (tryBind > 0L) {
            ChannelFuture cf = this.bindHost.isEmpty() ? bootstrap.bind((SocketAddress)new InetSocketAddress(listenPort)) : bootstrap.bind((SocketAddress)new InetSocketAddress(this.bindHost, listenPort));
            cf.await();
            if (cf.isSuccess()) {
                LOGGER.warn("HSF listened on: " + listenPort);
                return;
            }
            if (--tryBind <= 0L) {
                LOGGER.warn("After 3 failed attempts to start server at port : " + listenPort + ", we are shutting down the vm");
                System.exit(1);
                continue;
            }
            LOGGER.warn("Failed to start server at port : " + listenPort + ", Sleep 3s and try again", new Object[]{cf.cause()});
            Thread.sleep(3000L);
        }
    }

    public List<Channel> listChannels() {
        return this.serverHandler.getChannels();
    }

    @Override
    public void stop() throws Exception {
        LOGGER.warn("Server stop!");
        this.startFlag.set(false);
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public void signalClosingServer() {
        RpcResponse msg = new RpcResponse(-1L, 4, new byte[1]);
        msg.setStatus(ResponseStatus.SERVER_CLOSING);
        for (Channel channel : this.serverHandler.getChannels()) {
            channel.writeAndFlush((Object)msg);
        }
    }

    @Override
    public void startHttp(int listenPort) throws Exception {
        if (!this.startHttpFlag.compareAndSet(false, true)) {
            return;
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)SystemPropertyUtil.getInt((String)"hsf.backlog.http", (int)100000))).option(ChannelOption.ALLOCATOR, (Object)NettySharedHolder.byteBufAllocator)).childOption(ChannelOption.ALLOCATOR, (Object)NettySharedHolder.byteBufAllocator).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("handler", (ChannelHandler)new NettyServerHttpHandler(NettyServer.this.rpcProcessor));
            }
        });
        long tryBind = 3L;
        while (tryBind > 0L) {
            ChannelFuture cf = bootstrap.bind((SocketAddress)new InetSocketAddress(this.bindHost, listenPort));
            cf.await();
            if (cf.isSuccess()) {
                LOGGER.warn("Server started http transport, while listen at: " + listenPort);
                return;
            }
            if (--tryBind <= 0L) {
                LOGGER.warn("After 3 failed attempts to start http transport at port : " + listenPort + ", we are shutting down the vm");
                System.exit(1);
                continue;
            }
            LOGGER.warn("Failed to start http transport at port : " + listenPort, new Object[]{cf.cause()});
            Thread.sleep(3000L);
        }
    }

    @Override
    public void closeConnections() {
        for (Connection connection : this.serverHandler.getConnections()) {
            try {
                connection.close();
            }
            catch (Exception e) {
                LOGGER.error("[Connection Close]", e.getMessage());
            }
        }
    }
}

