/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.server;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.netty.NettySharedHolder;
import com.taobao.hsf.remoting.netty.server.NettyServerHandler;
import com.taobao.middleware.logger.Logger;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ScanAllClientRunnerServerSide
implements TimerTask {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final NettyServerHandler serverHandler;

    public ScanAllClientRunnerServerSide(NettyServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) throws Exception {
        try {
            long now = System.currentTimeMillis();
            List<Connection> connections = this.serverHandler.getConnections();
            if (connections != null) {
                for (Connection conn : connections) {
                    if (now - conn.getLastReadTime() <= 59000L) continue;
                    LOGGER.warn(conn + " is closed by server's scanRunner");
                    conn.close();
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("", "error during scanALLClients on server side:", e);
        }
        finally {
            NettySharedHolder.timer.newTimeout((TimerTask)this, 59L, TimeUnit.SECONDS);
        }
    }
}

