/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.protocol;

import com.taobao.hsf.remoting.HandshakeRequest;
import com.taobao.hsf.remoting.HandshakeResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.Protocol;

public class HandshakeProtocol
implements Protocol {
    public static final byte HANDSHAKE_PROTOCOL = 15;
    public static final int CUSTOMPROTOCOL_HEADER_LEN = 18;
    public static final byte VERSION = 1;
    public static final byte REQUEST = 0;
    public static final byte RESPONSE = 1;

    @Override
    public Object decode(ByteBufferWrapper wrapper, int originPos) throws Exception {
        if (wrapper.readableBytes() < 17) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte type = wrapper.readByte();
        byte version = wrapper.readByte();
        if (version == 1) {
            if (type == 0) {
                wrapper.readByte();
                wrapper.readByte();
                wrapper.readByte();
                long requestId = wrapper.readLong();
                int timeout = wrapper.readInt();
                HandshakeRequest requestWrapper = new HandshakeRequest(requestId, timeout);
                return requestWrapper;
            }
            if (type == 1) {
                wrapper.readByte();
                wrapper.readByte();
                wrapper.readByte();
                long requestId = wrapper.readLong();
                wrapper.readInt();
                return new HandshakeResponse(requestId);
            }
            throw new Exception("protocol type :" + type + " is not supported!");
        }
        throw new Exception("protocol version :" + version + " is not supported!");
    }
}

