/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.protocol;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.RpcRequest;
import com.taobao.hsf.remoting.RpcResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.Protocol;
import com.taobao.hsf.remoting.util.ThreadLocalCache;
import com.taobao.middleware.logger.Logger;

public class RPCProtocol
implements Protocol {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    public static final int REQUEST_HEADER_LEN = 30;
    public static final int RESPONSE_HEADER_LEN = 20;
    public static final byte VERSION = 1;
    public static final byte REQUEST = 0;
    public static final byte RESPONSE = 1;

    @Override
    public Object decode(ByteBufferWrapper wrapper, int originPos) throws Exception {
        if (wrapper.readableBytes() < 2) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte version = wrapper.readByte();
        if (version == 1) {
            byte type = wrapper.readByte();
            if (type == 0) {
                return this.decodeRequest(wrapper, originPos);
            }
            if (type == 1) {
                return this.decodeRpcResponse(wrapper, originPos);
            }
            LOGGER.error("", "protocol type : " + type + " is not supported!");
            return null;
        }
        LOGGER.error("", "protocol version :" + version + " is not supported!");
        return null;
    }

    private Object decodeRequest(ByteBufferWrapper wrapper, int originPos) {
        int expectedLenInfoLen;
        if (wrapper.readableBytes() < 28) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte codecType = wrapper.readByte();
        wrapper.setReaderIndex(wrapper.readerIndex() + 3);
        long requestId = wrapper.readLong();
        int timeout = wrapper.readInt();
        int targetInstanceLen = wrapper.readInt();
        int methodNameLen = wrapper.readInt();
        int argsCount = wrapper.readInt();
        int argInfosLen = argsCount * 4 * 2;
        int size = expectedLenInfoLen = argInfosLen + targetInstanceLen + methodNameLen + 4;
        if (wrapper.readableBytes() < expectedLenInfoLen) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        int expectedLen = 0;
        int[] argsTypeLen = new int[argsCount];
        for (int i = 0; i < argsCount; ++i) {
            argsTypeLen[i] = wrapper.readInt();
            expectedLen += argsTypeLen[i];
        }
        int[] argsLen = new int[argsCount];
        for (int i = 0; i < argsCount; ++i) {
            argsLen[i] = wrapper.readInt();
            expectedLen += argsLen[i];
        }
        int requestPropLength = wrapper.readInt();
        byte[] targetInstanceByte = new byte[targetInstanceLen];
        wrapper.readBytes(targetInstanceByte);
        byte[] methodNameByte = new byte[methodNameLen];
        wrapper.readBytes(methodNameByte);
        size += (expectedLen += requestPropLength);
        if (wrapper.readableBytes() < expectedLen) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte[][] argTypes = new byte[argsCount][];
        for (int i = 0; i < argsCount; ++i) {
            byte[] argTypeByte = new byte[argsTypeLen[i]];
            wrapper.readBytes(argTypeByte);
            argTypes[i] = argTypeByte;
        }
        byte[][] args = new byte[argsCount][];
        for (int i = 0; i < argsCount; ++i) {
            byte[] argByte = new byte[argsLen[i]];
            wrapper.readBytes(argByte);
            args[i] = argByte;
        }
        byte[] requestPropBytes = new byte[requestPropLength];
        wrapper.readBytes(requestPropBytes);
        String[] argTypeStrings = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypeStrings[i] = ThreadLocalCache.getString(argTypes[i]);
        }
        return new RpcRequest(requestId, timeout, ThreadLocalCache.getString(targetInstanceByte), ThreadLocalCache.getString(methodNameByte), argTypeStrings, args, requestPropBytes, codecType, size);
    }

    private Object decodeRpcResponse(ByteBufferWrapper wrapper, int originPos) {
        if (wrapper.readableBytes() < 18) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte status = wrapper.readByte();
        byte codecType = wrapper.readByte();
        wrapper.setReaderIndex(wrapper.readerIndex() + 3);
        long requestId = wrapper.readLong();
        int bodyLen = wrapper.readInt();
        if (wrapper.readableBytes() < bodyLen) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte[] bodyBytes = new byte[bodyLen];
        wrapper.readBytes(bodyBytes);
        return new RpcResponse(requestId, codecType, status, bodyBytes);
    }
}

