/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.provider;

import com.alibaba.common.lang.diagnostic.Profiler;
import com.taobao.common.sentinel.hsf.manager.HsfSphManager;
import com.taobao.hsf.ServiceInvokeTransform;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ProviderMethodModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.monitor.service.MonitorService;
import com.taobao.hsf.plugins.octopus.HSFMockResult;
import com.taobao.hsf.plugins.octopus.MockHookService;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.pool.ThreadPoolManager;
import com.taobao.hsf.remoting.rt.RTPrinter;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.output.ServerOutput;
import com.taobao.hsf.rpc.provider.async.AsyncContext;
import com.taobao.hsf.tps.service.TPSLimitService;
import com.taobao.hsf.tps.service.TPSResult;
import com.taobao.hsf.unit.service.UnitService;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.PojoUtils;
import com.taobao.hsf.util.ReflectUtils;
import com.taobao.hsf.util.ServiceIndexUtil;
import com.taobao.hsf.util.ThreadLocalUtil;
import com.taobao.hsf.util.ThreadPoolUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.spas.sdk.common.service.SpasAuthorityResult;
import com.taobao.spas.sdk.service.SpasSdkServiceFacade;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class ProviderProcessor
implements RpcRequestProcessor {
    private static final String HSF_PROVIDER_TIMEOUT = "HSF-Provider-Timeout";
    private static final String HSF_PROVIDER_DETAIL = "HSF-ProviderDetail";
    private static final String HSF_PROVIDER_RTMINMAX = "HSF-ProviderRtMinmax";
    private static final String HSF_PROVIDER_DETAIL_BIZ_EXCEPTION = "HSF-ProviderDetail-BizException";
    private static final String HSF_PROVIDER_DETAIL_EXCEPTION = "HSF-ProviderDetail-Exception";
    private static final String HSF_PROVIDER_ACTIVE_THREAD = "HSF-Provider-ActiveThread";
    private static final String RESOURCE_PREFIX = "acs:hsf::";
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String EAGLEEYE_CONTEXT = "eagleeye_context";
    private static final String PROFILER_THREAD_START = "HSF\u670d\u52a1\u5f00\u59cb\u6267\u884c...";
    private static final String OCTOPUS2 = "octopus";
    private static final Field causeField;
    private final TPSLimitService tpsLimitService = HSFServiceContainer.getInstance(TPSLimitService.class);
    private final MockHookService mockHookService = HSFServiceContainer.getInstance(MockHookService.class);
    private final ApplicationModel applicationModel = ApplicationModel.instance();
    private final ThreadPoolManager threadPoolManager = ThreadPoolUtil.getThreadPoolManager();
    private final UnitService unitService = HSFServiceContainer.getInstance(UnitService.class);
    private final LogService logService = HSFServiceContainer.getInstance(LogService.class);
    private final MonitorService monitorService = HSFServiceContainer.getInstance(MonitorService.class);
    private final ConfigurationService configService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private static boolean auth;

    @Override
    public Executor getExecutor(String serviceName) {
        return this.threadPoolManager.getThreadExecutor(serviceName);
    }

    @Override
    public ThreadPoolManager getThreadPoolManager() {
        return this.threadPoolManager;
    }

    @Override
    public void handleRequest(HSFRequest hsfRequest, ServerOutput outputStream) {
        Object ctimestamp;
        ProviderMethodModel pmm;
        String serviceUniqueName = hsfRequest.getTargetServiceUniqueName();
        String methodName = hsfRequest.getMethodName();
        Connection connection = outputStream.getConnection();
        String clientIp = connection.getPeerIP();
        ProviderServiceModel psm = ApplicationModel.instance().getProvidedServiceModel(serviceUniqueName);
        if (auth && psm != null && (pmm = psm.getMethodModel(methodName, hsfRequest.getMethodArgSigs())) != null && (ctimestamp = hsfRequest.getRequestProp("Time-Stamp")) != null) {
            String signature = (String)hsfRequest.getRequestProp("Spas-Signature");
            String accesskey = (String)hsfRequest.getRequestProp("Access-Key");
            String appName = (String)hsfRequest.getRequestProp("Consumer-AppName");
            String version = (String)hsfRequest.getRequestProp("Spas-Version");
            if (!SpasSdkServiceFacade.verifySignature((String)signature, (String)accesskey, (String)ctimestamp.toString(), (String)appName, (String)version)) {
                String errorMsg = MessageFormat.format("[HSF-Provider] The request for [{0}] [{1}] from [{2}] is not authorised by SPAS signature rule.", serviceUniqueName, methodName, clientIp);
                this.logService.responseSize(outputStream.writeHSFResponse(this.spasFail(serviceUniqueName, methodName, clientIp, hsfRequest, errorMsg)));
                return;
            }
            String action = pmm.getSpasMethodName();
            String resource = RESOURCE_PREFIX + serviceUniqueName + ":" + psm.getMetadata().getGroup();
            SpasAuthorityResult res = SpasSdkServiceFacade.checkAuthorityDetail((String)accesskey, (String)resource, (String)action, (String)appName, (String)version);
            if (!res.getResult()) {
                String errorMsg = MessageFormat.format("[HSF-Provider] The request for [{0}] [{1}] from [{2}] is not authorised by SPAS rule.", serviceUniqueName, methodName, clientIp);
                this.logService.responseSize(outputStream.writeHSFResponse(this.spasFail(serviceUniqueName, methodName, clientIp, hsfRequest, errorMsg)));
                return;
            }
        }
        if (this.applicationModel.isSupportTps()) {
            try {
                TPSResult result = this.tpsLimitService.process(hsfRequest);
                if (!result.isAllowed()) {
                    this.logService.responseSize(outputStream.writeHSFResponse(this.processTpsNotAllowed(hsfRequest, serviceUniqueName, methodName, clientIp, result)));
                    return;
                }
            }
            catch (Throwable t) {
                LOGGER.warn(MessageFormat.format("[HSF-Provider] TPS rule executed error, TPS rule: {0}, HSF request: {1}.", this.tpsLimitService, hsfRequest));
            }
        }
        HSFResponse hsfResponse = null;
        if (this.unitService != null && this.unitService.isUnitModel() && (hsfResponse = this.processUnitCondition(hsfRequest, serviceUniqueName, methodName, clientIp)) != null) {
            this.logService.responseSize(outputStream.writeHSFResponse(hsfResponse));
        }
        if (hsfResponse == null) {
            byte protocol = hsfRequest.getSerializeType();
            hsfResponse = 3 == protocol ? this.handleTopRequest(hsfRequest, serviceUniqueName, methodName, outputStream) : this.handleRequest0(hsfRequest, outputStream, null, null);
            ThreadLocalUtil.remove();
            if (hsfResponse != null) {
                this.handleEagleEyeResponseSend(hsfResponse);
                this.logService.responseSize(outputStream.writeHSFResponse(hsfResponse));
            }
        }
        if (this.configService.isRtCollect()) {
            RTPrinter.collect(serviceUniqueName, System.currentTimeMillis() - outputStream.getStartTime());
        }
    }

    private HSFResponse spasFail(String serviceUniqueName, String methodName, String clientIp, HSFRequest hsfRequest, String errorMsg) {
        this.monitorService.add("HSF-SPAS-REJECTED-SPAS", serviceUniqueName, methodName, clientIp, 1L, 1L);
        this.handleEagleEyeServerRecv(hsfRequest, clientIp);
        this.logService.rpcServerSend("02", "SPAS");
        LOGGER.warn(errorMsg);
        HSFResponse hsfResponse = new HSFResponse();
        hsfResponse.setErrorMsg(errorMsg);
        return hsfResponse;
    }

    private HSFResponse processUnitCondition(HSFRequest hsfRequest, String serviceUniqueName, String methodName, String clientIp) {
        block6: {
            try {
                ProviderServiceModel serviceModel = this.applicationModel.getProvidedServiceModel(serviceUniqueName);
                if (null == serviceModel) {
                    this.handleEagleEyeServerRecv(hsfRequest, clientIp);
                    HSFResponse hsfResponse = new HSFResponse();
                    hsfResponse.setErrorMsg("[HSF-Provider] \u672a\u627e\u5230\u4e1a\u52a1\u670d\u52a1\u7684MetaData\uff0c\u670d\u52a1\u540d\u79f0\uff1a" + serviceUniqueName);
                    LOGGER.warn("[HSF-Provider] \u672a\u627e\u5230\u4e1a\u52a1\u670d\u52a1\u7684MetaData\uff0c\u670d\u52a1\u540d\u79f0\uff1a" + serviceUniqueName);
                    this.logService.rpcServerSend("02", "NS");
                    return hsfResponse;
                }
                ServiceMetadata metadata = serviceModel.getMetadata();
                Object[] methodArgs = hsfRequest.getMethodArgs();
                String writeMode = metadata.getWriteMode();
                if (writeMode == null) break block6;
                if (writeMode.equals("unit")) {
                    int route = metadata.getRoute();
                    Object uid = hsfRequest.getRequestProp("_hsf_unit_deploy_user_id");
                    long userId = uid != null ? ((Long)uid).longValue() : ((Long)methodArgs[route]).longValue();
                    if (!this.unitService.isInCurrentUnit(userId)) {
                        this.handleEagleEyeServerRecv(hsfRequest, clientIp);
                        return this.unitService.doNotInCurrentUnit(hsfRequest, clientIp, serviceUniqueName, methodName, userId);
                    }
                    this.logService.attribute("b", String.valueOf(userId) + "_u");
                    break block6;
                }
                if (!writeMode.equals("center")) break block6;
                if (this.unitService.isCenterUnit()) {
                    this.logService.attribute("b", "c");
                    break block6;
                }
                this.handleEagleEyeServerRecv(hsfRequest, clientIp);
                return this.unitService.doNotInCenterUnit(hsfRequest, clientIp, serviceUniqueName, methodName);
            }
            catch (Throwable t) {
                this.handleEagleEyeServerRecv(hsfRequest, clientIp);
                LOGGER.error("", MessageFormat.format("[HSF-Provider] UnitRule Protection error, request for [{0}] [{1}] from [{2}], currentUnit [{3}]", serviceUniqueName, methodName, clientIp, this.unitService.getCurrentUnit()), t);
                HSFResponse hsfResponse = new HSFResponse();
                hsfResponse.setErrorMsg(MessageFormat.format("[HSF-Provider] The request for [{0}] [{1}] from [{2}] is rejected because HSF throw an exception when performing UnitProtectionCheck, currentUnit [{3}]", serviceUniqueName, methodName, clientIp, this.unitService.getCurrentUnit()));
                this.logService.rpcServerSend("02", "UNIT");
                return hsfResponse;
            }
        }
        return null;
    }

    private HSFResponse processTpsNotAllowed(HSFRequest hsfRequest, String serviceUniqueName, String methodName, String clientIp, TPSResult result) {
        this.monitorService.add("HSF-TPS-REJECTED-" + result.getMessage(), serviceUniqueName, methodName, clientIp, 1L, 1L);
        this.handleEagleEyeServerRecv(hsfRequest, clientIp);
        this.logService.rpcServerSend("02", "TPS");
        HSFResponse hsfResponse = new HSFResponse();
        hsfResponse.setErrorMsg(MessageFormat.format("[HSF-Provider] The request for [{0}] [{1}] from [{2}] is blocked by TPS rule: {3}.", serviceUniqueName, methodName, clientIp, result.getMessage()));
        return hsfResponse;
    }

    private HSFResponse handleTopRequest(HSFRequest hsfRequest, String serviceUniqueName, String methodName, ServerOutput outputStream) {
        HSFResponse hsfResponse;
        String clientIp = outputStream.getConnection().getPeerIP();
        this.handleEagleEyeServerRecv(hsfRequest, clientIp);
        Object[] originalArgs = null;
        String[] originalArgTypes = null;
        ServiceInvokeTransform transform = ServiceInvokeTransform.Helper.find(serviceUniqueName);
        if (null == transform) {
            hsfResponse = new HSFResponse();
            hsfResponse.setErrorMsg(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0029", (String)"Biz-Problem", (String)("TOP\u6ca1\u6709\u6ce8\u518c\u670d\u52a1[" + serviceUniqueName + "]\u7684\u8f6c\u6362\u7c7b\u3002")));
            hsfResponse.setErrorType("TOP1");
        } else {
            try {
                originalArgs = hsfRequest.getMethodArgs();
                originalArgTypes = hsfRequest.getMethodArgSigs();
                hsfRequest.setMethodArgs(transform.transformRequest(methodName, originalArgs, originalArgTypes));
                hsfRequest.setMethodArgSigs(transform.transformRequestTypes(methodName, originalArgs, originalArgTypes));
                hsfResponse = this.handleRequest0(hsfRequest, outputStream, originalArgs, originalArgTypes);
            }
            catch (Exception e) {
                hsfResponse = new HSFResponse();
                hsfResponse.setErrorType("TOP2");
                hsfResponse.setErrorMsg("TOP\u5728\u5bf9\u670d\u52a1[" + serviceUniqueName + "]\u7684\u8c03\u7528\u53c2\u6570\u8fdb\u884c\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\u3002" + e.getMessage());
            }
            try {
                hsfResponse.setAppResponse(transform.transformResponse(hsfRequest.getMethodName(), originalArgs, originalArgTypes, hsfResponse.getAppResponse()));
            }
            catch (Exception e) {
                hsfResponse = new HSFResponse();
                hsfResponse.setErrorType("TOP3");
                hsfResponse.setErrorMsg("TOP\u5728\u5bf9\u670d\u52a1[" + serviceUniqueName + "]\u7684\u8fd4\u56de\u7ed3\u679c\u8fdb\u884c\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\u3002" + e.getMessage());
            }
        }
        return hsfResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HSFResponse handleRequest0(HSFRequest hsfRequest, ServerOutput output, Object[] originalArgs, String[] originalArgTypes) {
        Object retobj;
        boolean isBizException;
        String methodName;
        ProviderMethodModel methodModel;
        ClassLoader tcl;
        String remoteHost;
        HSFResponse hsfResponse;
        String serviceUniqueName;
        block31: {
            Object appResp;
            boolean isGeneric;
            block32: {
                block33: {
                    String clientAppName;
                    Method workerMethod;
                    Object[] sig;
                    ProviderServiceModel serviceModel;
                    block30: {
                        block29: {
                            serviceUniqueName = hsfRequest.getTargetServiceUniqueName();
                            serviceModel = this.applicationModel.getProvidedServiceModel(serviceUniqueName);
                            hsfResponse = new HSFResponse();
                            remoteHost = output.getConnection().getPeerIP();
                            if (null == serviceModel) {
                                hsfResponse.setErrorMsg("[HSF-Provider] \u672a\u627e\u5230\u4e1a\u52a1\u670d\u52a1\uff0c\u670d\u52a1\u540d\u79f0\uff1a" + serviceUniqueName);
                                LOGGER.warn("[HSF-Provider] \u672a\u627e\u5230\u4e1a\u52a1\u670d\u52a1\uff0c\u670d\u52a1\u540d\u79f0\uff1a" + serviceUniqueName);
                                hsfResponse.setErrorType("NS");
                                return hsfResponse;
                            }
                            Profiler.reset();
                            Profiler.start((String)PROFILER_THREAD_START);
                            sig = hsfRequest.getMethodArgSigs();
                            isGeneric = false;
                            tcl = Thread.currentThread().getContextClassLoader();
                            methodModel = null;
                            methodName = hsfRequest.getMethodName();
                            this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, 1L, 1L);
                            isBizException = false;
                            retobj = null;
                            if (!methodName.equals("$echo") || sig == null || sig.length != 1) break block29;
                            hsfResponse.setAppResponse(hsfRequest.getMethodArgs()[0]);
                            HSFResponse hSFResponse = hsfResponse;
                            Thread.currentThread().setContextClassLoader(tcl);
                            Profiler.release();
                            this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                            long duration = System.currentTimeMillis() - output.getStartTime();
                            if (methodModel == null) return hSFResponse;
                            methodModel.setResponseTime((int)duration);
                            methodModel.getElapseTime().addAndGet((int)duration);
                            methodModel.getInvokeCount().incrementAndGet();
                            methodModel.getThreadCount().decrementAndGet();
                            String logMethodName = methodModel.getMethodLogname();
                            this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
                            this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
                            if (this.logService.isLogDumpEnabled()) {
                                String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
                                this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                            }
                            if (duration < (long)(methodModel.getTimeout() - 100)) return hSFResponse;
                            this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
                            String detail = Profiler.dump();
                            LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
                            return hSFResponse;
                        }
                        if (methodName.equals("$invoke") && sig != null && sig.length == 3) {
                            Object[] methodArgs = hsfRequest.getMethodArgs();
                            methodName = ((String)methodArgs[0]).trim();
                            sig = (String[])methodArgs[1];
                            for (int i = 0; i < sig.length; ++i) {
                                try {
                                    sig[i] = ReflectUtils.name2class(sig[i]).getName();
                                    continue;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                            isGeneric = true;
                        }
                        if ((methodModel = serviceModel.getMethodModel(methodName, (String[])sig)) == null) {
                            this.handleEagleEyeServerRecv(hsfRequest, remoteHost);
                            throw new NoSuchMethodException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0030", (String)"Biz-Problem", (String)("[HSF-Provider] \u672a\u627e\u5230\u9700\u8981\u8c03\u7528\u7684\u65b9\u6cd5:" + methodName + ";\u670d\u52a1\u540d\u4e3a:" + serviceUniqueName + ";\u53c2\u6570:" + methodName + Arrays.toString(sig))));
                        }
                        methodModel.getThreadCount().incrementAndGet();
                        this.handleEagleEyeServerRecv(hsfRequest, remoteHost, methodModel.getMethodLogname());
                        workerMethod = methodModel.getMethod();
                        clientAppName = this.getAppNameOfClient(hsfRequest);
                        boolean sphPass = HsfSphManager.verifybySentinel((String)clientAppName, (Method)workerMethod);
                        if (sphPass) break block30;
                        hsfResponse.setErrorType("SPH");
                        hsfResponse.setErrorMsg(MessageFormat.format("[HSF-Provider] The request for [{0}] [{1}] from [{2}] is blocked by SPH.", serviceUniqueName, methodName, remoteHost));
                        HSFResponse logMethodName = hsfResponse;
                        Thread.currentThread().setContextClassLoader(tcl);
                        Profiler.release();
                        this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                        long duration = System.currentTimeMillis() - output.getStartTime();
                        if (methodModel == null) return logMethodName;
                        methodModel.setResponseTime((int)duration);
                        methodModel.getElapseTime().addAndGet((int)duration);
                        methodModel.getInvokeCount().incrementAndGet();
                        methodModel.getThreadCount().decrementAndGet();
                        String logMethodName2 = methodModel.getMethodLogname();
                        this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName2, remoteHost, 1L, duration);
                        this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName2, duration);
                        if (this.logService.isLogDumpEnabled()) {
                            String operationKey = serviceUniqueName + "#" + logMethodName2 + "#" + remoteHost;
                            this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                        }
                        if (duration < (long)(methodModel.getTimeout() - 100)) return logMethodName;
                        this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName2, 1L, duration);
                        String detail = Profiler.dump();
                        LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName2, duration, remoteHost, detail)));
                        return logMethodName;
                    }
                    boolean needInvoke = true;
                    if (this.mockHookService != null) {
                        needInvoke = this.processMockRequest(serviceUniqueName, hsfResponse, (String[])sig, methodName, workerMethod, needInvoke);
                    }
                    this.preInvoke(serviceModel);
                    if (!needInvoke) break block31;
                    Method m2InjectCosumerIP = serviceModel.getInjectConsumerIpMethod();
                    if (m2InjectCosumerIP != null) {
                        this.injectCosumerIp(m2InjectCosumerIP, serviceModel.getServiceInstance(), remoteHost);
                    }
                    Object[] methodArgs = hsfRequest.getMethodArgs();
                    if (isGeneric) {
                        Class<?>[] params = workerMethod.getParameterTypes();
                        if (methodArgs == null) {
                            methodArgs = new Object[params.length];
                        }
                        methodArgs = PojoUtils.realize((Object[])methodArgs[2], params, workerMethod.getGenericParameterTypes());
                    }
                    HashMap<String, Object> localThreadMap = new HashMap<String, Object>(2);
                    localThreadMap.put("_remote_ip", remoteHost);
                    localThreadMap.put("_hsf_appname_c", clientAppName);
                    ThreadLocalUtil.set(localThreadMap);
                    AsyncContext asyncContext = new AsyncContext(this.monitorService, this.logService, output, hsfRequest, originalArgs, originalArgTypes, isGeneric, methodModel);
                    ThreadLocalUtil.set("_hsf_async_context", asyncContext);
                    Thread.currentThread().setContextClassLoader(serviceModel.getMetadata().getServicePojoClassLoader());
                    appResp = workerMethod.invoke(serviceModel.getServiceInstance(), methodArgs);
                    if (ThreadLocalUtil.get("_hsf_aysnc_started") == null) break block32;
                    if (!(hsfResponse.getAppResponse() instanceof Throwable)) break block33;
                    if (asyncContext.closeAsync("\u4e1a\u52a1\u65b9\u6cd5\u5f02\u5e38", (Throwable)hsfResponse.getAppResponse())) break block32;
                    HSFResponse hSFResponse = null;
                    Thread.currentThread().setContextClassLoader(tcl);
                    Profiler.release();
                    this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                    long duration = System.currentTimeMillis() - output.getStartTime();
                    if (methodModel == null) return hSFResponse;
                    methodModel.setResponseTime((int)duration);
                    methodModel.getElapseTime().addAndGet((int)duration);
                    methodModel.getInvokeCount().incrementAndGet();
                    methodModel.getThreadCount().decrementAndGet();
                    String logMethodName = methodModel.getMethodLogname();
                    this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
                    this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
                    if (this.logService.isLogDumpEnabled()) {
                        String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
                        this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                    }
                    if (duration < (long)(methodModel.getTimeout() - 100)) return hSFResponse;
                    this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
                    String detail = Profiler.dump();
                    LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
                    return hSFResponse;
                }
                HSFResponse hSFResponse = null;
                Thread.currentThread().setContextClassLoader(tcl);
                Profiler.release();
                this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                long duration = System.currentTimeMillis() - output.getStartTime();
                if (methodModel == null) return hSFResponse;
                methodModel.setResponseTime((int)duration);
                methodModel.getElapseTime().addAndGet((int)duration);
                methodModel.getInvokeCount().incrementAndGet();
                methodModel.getThreadCount().decrementAndGet();
                String logMethodName = methodModel.getMethodLogname();
                this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
                this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
                if (this.logService.isLogDumpEnabled()) {
                    String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
                    this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                }
                if (duration < (long)(methodModel.getTimeout() - 100)) return hSFResponse;
                this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
                String detail = Profiler.dump();
                LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
                return hSFResponse;
            }
            try {
                if (isGeneric) {
                    appResp = PojoUtils.generalize(appResp);
                }
                hsfResponse.setAppResponse(appResp);
                retobj = appResp;
            }
            catch (InvocationTargetException ivke) {
                isBizException = true;
                this.processBizException(hsfRequest, remoteHost, serviceUniqueName, hsfResponse, isGeneric, methodName, ivke);
                retobj = ivke.getCause().getMessage();
                Thread.currentThread().setContextClassLoader(tcl);
                Profiler.release();
                this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                long duration = System.currentTimeMillis() - output.getStartTime();
                if (methodModel == null) return hsfResponse;
                methodModel.setResponseTime((int)duration);
                methodModel.getElapseTime().addAndGet((int)duration);
                methodModel.getInvokeCount().incrementAndGet();
                methodModel.getThreadCount().decrementAndGet();
                String logMethodName = methodModel.getMethodLogname();
                this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
                this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
                if (this.logService.isLogDumpEnabled()) {
                    String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
                    this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                }
                if (duration < (long)(methodModel.getTimeout() - 100)) return hsfResponse;
                this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
                String detail = Profiler.dump();
                LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
                return hsfResponse;
            }
            catch (Throwable t) {
                this.processUnknownException(hsfRequest, remoteHost, serviceUniqueName, hsfResponse, methodName, t);
                retobj = t.getMessage();
                Thread.currentThread().setContextClassLoader(tcl);
                {
                    catch (Throwable throwable) {
                        Thread.currentThread().setContextClassLoader(tcl);
                        Profiler.release();
                        this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                        long duration = System.currentTimeMillis() - output.getStartTime();
                        if (methodModel == null) throw throwable;
                        methodModel.setResponseTime((int)duration);
                        methodModel.getElapseTime().addAndGet((int)duration);
                        methodModel.getInvokeCount().incrementAndGet();
                        methodModel.getThreadCount().decrementAndGet();
                        String logMethodName = methodModel.getMethodLogname();
                        this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
                        this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
                        if (this.logService.isLogDumpEnabled()) {
                            String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
                            this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                        }
                        if (duration < (long)(methodModel.getTimeout() - 100)) throw throwable;
                        this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
                        String detail = Profiler.dump();
                        LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
                        throw throwable;
                    }
                }
                Profiler.release();
                this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
                long duration = System.currentTimeMillis() - output.getStartTime();
                if (methodModel == null) return hsfResponse;
                methodModel.setResponseTime((int)duration);
                methodModel.getElapseTime().addAndGet((int)duration);
                methodModel.getInvokeCount().incrementAndGet();
                methodModel.getThreadCount().decrementAndGet();
                String logMethodName = methodModel.getMethodLogname();
                this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
                this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
                if (this.logService.isLogDumpEnabled()) {
                    String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
                    this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
                }
                if (duration < (long)(methodModel.getTimeout() - 100)) return hsfResponse;
                this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
                String detail = Profiler.dump();
                LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
                return hsfResponse;
            }
        }
        Thread.currentThread().setContextClassLoader(tcl);
        Profiler.release();
        this.monitorService.add(HSF_PROVIDER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
        long duration = System.currentTimeMillis() - output.getStartTime();
        if (methodModel == null) return hsfResponse;
        methodModel.setResponseTime((int)duration);
        methodModel.getElapseTime().addAndGet((int)duration);
        methodModel.getInvokeCount().incrementAndGet();
        methodModel.getThreadCount().decrementAndGet();
        String logMethodName = methodModel.getMethodLogname();
        this.monitorService.add(hsfResponse.isError() ? HSF_PROVIDER_DETAIL_EXCEPTION : (isBizException ? HSF_PROVIDER_DETAIL_BIZ_EXCEPTION : HSF_PROVIDER_DETAIL), serviceUniqueName, logMethodName, remoteHost, 1L, duration);
        this.monitorService.minMax(HSF_PROVIDER_RTMINMAX, serviceUniqueName, logMethodName, duration);
        if (this.logService.isLogDumpEnabled()) {
            String operationKey = serviceUniqueName + "#" + logMethodName + "#" + remoteHost;
            this.logService.dump(AppInfoUtils.getAppName(), operationKey, retobj == null ? Void.TYPE : retobj, hsfRequest.getMethodArgs());
        }
        if (duration < (long)(methodModel.getTimeout() - 100)) return hsfResponse;
        this.monitorService.add(HSF_PROVIDER_TIMEOUT, serviceUniqueName, logMethodName, 1L, duration);
        String detail = Profiler.dump();
        LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0031", (String)"Biz-Problem", (String)MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n", serviceUniqueName, logMethodName, duration, remoteHost, detail)));
        return hsfResponse;
    }

    private boolean processMockRequest(String serviceUniqueName, HSFResponse hsfResponse, String[] sig, String methodName, Method workerMethod, boolean needInvoke) {
        String octopus = this.logService.getUserData(OCTOPUS2);
        try {
            HSFMockResult result = this.mockHookService.beforeProcess(octopus, workerMethod, serviceUniqueName, methodName, sig);
            if (result != null && result.isValidMock()) {
                Object appResponse = result.getMockValue();
                hsfResponse.setAppResponse(appResponse);
                needInvoke = false;
            }
        }
        catch (Throwable e) {
            if (e instanceof HSFException) {
                hsfResponse.setAppResponse(e);
            } else {
                hsfResponse.setAppResponse(new HSFException("HSF Mock \u5f02\u5e38", e));
            }
            needInvoke = false;
        }
        return needInvoke;
    }

    private void processUnknownException(HSFRequest hsfRequest, String remoteHost, String serviceUniqueName, HSFResponse hsfResponse, String methodName, Throwable t) {
        StringBuilder errBuilder = new StringBuilder();
        errBuilder.append("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[");
        errBuilder.append(serviceUniqueName);
        errBuilder.append("]\u7684\u65b9\u6cd5[");
        errBuilder.append(methodName);
        errBuilder.append("]\u65f6\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff1a").append(t.getMessage()).append("\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[");
        errBuilder.append(remoteHost);
        errBuilder.append("]\uff0c\u6267\u884c\u7684\u53c2\u6570\u4e3a\uff1a[");
        Object[] methodArgs = hsfRequest.getMethodArgs();
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                errBuilder.append(methodArgs[i]);
                errBuilder.append(",");
            }
        }
        errBuilder.append("]");
        errBuilder.append(" TraceId=").append(this.logService.getTraceId());
        errBuilder.append(", RpcId=").append(this.logService.getRpcId());
        hsfResponse.setErrorMsg(errBuilder.toString());
        hsfResponse.setErrorType(t.getClass().getSimpleName());
        LOGGER.warn(errBuilder.toString(), new Object[]{t});
    }

    private void processBizException(HSFRequest hsfRequest, String remoteHost, String serviceUniqueName, HSFResponse hsfResponse, boolean isGeneric, String methodName, InvocationTargetException ivke) {
        Throwable bizException = ivke.getCause();
        StringBuilder errBuilder = new StringBuilder();
        errBuilder.append("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[");
        errBuilder.append(serviceUniqueName);
        errBuilder.append("]\u7684\u65b9\u6cd5[");
        errBuilder.append(methodName);
        errBuilder.append("]\u65f6\u51fa\u73b0\u4e1a\u52a1\u5f02\u5e38\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[");
        errBuilder.append(remoteHost);
        errBuilder.append("]\uff0c\u6267\u884c\u7684\u53c2\u6570\u4e3a\uff1a[");
        Object[] methodArgs = hsfRequest.getMethodArgs();
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                errBuilder.append(methodArgs[i]);
                errBuilder.append(",");
            }
        }
        errBuilder.append("]");
        errBuilder.append(" TraceId=").append(this.logService.getTraceId()).append("\n");
        errBuilder.append(", RpcId=").append(this.logService.getRpcId()).append("\n");
        if (ThreadLocalUtil.get("_hsf_aysnc_started") != null) {
            errBuilder.append("\u5f02\u6b65\u5df2\u5f00\u542f\n");
        }
        LOGGER.warn(errBuilder.toString(), new Object[]{bizException});
        this.cutCause(bizException);
        if (isGeneric) {
            hsfResponse.setAppResponse(PojoUtils.generalize(bizException));
        } else {
            hsfResponse.setAppResponse(bizException);
        }
        hsfResponse.setErrorType(bizException.getClass().getSimpleName());
    }

    private void handleEagleEyeResponseSend(HSFResponse hsfResponse) {
        if (hsfResponse.getErrorType() != null) {
            if (hsfResponse.isError()) {
                this.logService.rpcServerSend("02", hsfResponse.getErrorType());
            } else {
                this.logService.rpcServerSendFailed(hsfResponse.getErrorType());
            }
        } else {
            this.logService.rpcServerSendSuccess();
        }
    }

    private void handleEagleEyeServerRecv(HSFRequest hsfRequest, String remoteHost) {
        String methodNameToLog = ServiceIndexUtil.getMethodNameToLog(hsfRequest.getMethodName(), hsfRequest.getMethodArgSigs());
        this.handleEagleEyeServerRecv(hsfRequest, remoteHost, methodNameToLog);
    }

    private String getAppNameOfClient(HSFRequest request) {
        String appName = (String)request.getRequestProp("Consumer-AppName");
        if (appName != null) {
            return appName;
        }
        return "UNKNOWN";
    }

    private void handleEagleEyeServerRecv(HSFRequest hsfRequest, String remoteHost, String methodLogName) {
        Object rpcCtx = hsfRequest.getRequestProp(EAGLEEYE_CONTEXT);
        this.logService.setRpcContext(rpcCtx);
        String serviceUniqueName = hsfRequest.getTargetServiceUniqueName();
        this.logService.rpcServerRecv(serviceUniqueName, methodLogName);
        this.logService.remoteIp(remoteHost);
    }

    private void cutCause(Throwable bizException) {
        Throwable rootCause = bizException;
        while (null != rootCause.getCause()) {
            rootCause = rootCause.getCause();
        }
        if (rootCause != bizException) {
            bizException.setStackTrace(rootCause.getStackTrace());
            try {
                causeField.set(bizException, bizException);
            }
            catch (Exception e) {
                LOGGER.warn("[HSF-Provider] \u5207\u65ad\u4e1a\u52a1\u8fde\u73af\u5f02\u5e38\u65f6\u51fa\u73b0\u5f02\u5e38.", new Object[]{e});
            }
        }
    }

    private void injectCosumerIp(Method method, Object servicePOJO, String consumerIP) {
        block2: {
            try {
                method.invoke(servicePOJO, consumerIP);
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn(MessageFormat.format("Could not set consumer IP for service object [{0}], method {1}", servicePOJO, method), new Object[]{t});
            }
        }
    }

    private void preInvoke(ProviderServiceModel serviceModel) {
        if (serviceModel.getMetadata().isEnableTXC()) {
            this.logService.putUserData("EnableTXC", "true");
        } else {
            this.logService.putUserData("EnableTXC", "false");
            this.logService.removeUserData("TXC_XID");
        }
    }

    static {
        try {
            causeField = Throwable.class.getDeclaredField("cause");
            causeField.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        auth = false;
        String needAuth = System.getProperty("needAuth");
        if (null != needAuth && !needAuth.isEmpty()) {
            needAuth = needAuth.trim();
            try {
                Boolean tmp = Boolean.valueOf(needAuth);
                auth = tmp;
            }
            catch (Throwable e) {
                LOGGER.error("", e.getMessage());
            }
        }
    }
}

