/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.rt;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.rt.AlivedFileOutputStream;
import com.taobao.hsf.remoting.rt.DeleteOutputStream;
import com.taobao.hsf.remoting.rt.RTCalculator;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public class RTPrinter {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    public static String LOG_DIR_PATH = System.getProperty("os.name").toLowerCase().contains("win") ? "" : "/home/admin/hsf/";
    private static Calendar CURRENT_DATE;
    private static PrintWriter PRINTWRITER;
    private static File LOG_FILE;
    public static final SimpleDateFormat LOG_FILE_FMT;
    private static final SimpleDateFormat LOG_CONTENT_FMT;
    private static final long TICK_NANO;
    private static final AtomicBoolean STARTED;
    private static Thread THREAD;
    private static final Runnable TASK;
    private static final ConcurrentHashMap<String, RTCalculator.ConcurrentRTProfile> PROFILE_MAP;

    public static final void collect(String name, long cost) {
        RTCalculator.ConcurrentRTProfile tmp;
        cost = Math.max(0L, cost);
        RTCalculator.ConcurrentRTProfile profile = PROFILE_MAP.get(name);
        if (null == profile && null != (tmp = PROFILE_MAP.putIfAbsent(name, profile = new RTCalculator.ConcurrentRTProfile()))) {
            profile = tmp;
        }
        profile.add(cost, 1);
    }

    private static final void write() {
        Calendar c = Calendar.getInstance();
        PrintWriter out = RTPrinter.getWriter(c);
        StringBuilder content = new StringBuilder("@###@ ");
        content.append(LOG_CONTENT_FMT.format(c.getTime())).append(" ");
        content.append(c.getTimeInMillis()).append(" ");
        HashMap<String, RTCalculator.ConcurrentRTProfile> metaData = new HashMap<String, RTCalculator.ConcurrentRTProfile>();
        for (Map.Entry<String, RTCalculator.ConcurrentRTProfile> entry : PROFILE_MAP.entrySet()) {
            metaData.put(entry.getKey(), entry.getValue());
        }
        PROFILE_MAP.clear();
        for (Map.Entry<String, RTCalculator.ConcurrentRTProfile> entry : metaData.entrySet()) {
            content.append(entry.getKey()).append(" ");
            content.append(entry.getValue().getCount()).append(" ");
            if (entry.getValue().getCount() == 0) {
                content.append("0").append(" ");
                continue;
            }
            content.append((float)entry.getValue().getElapsedTime() / (float)entry.getValue().getCount()).append(" ");
        }
        out.println(content.toString());
        out.flush();
    }

    private static PrintWriter getWriter(Calendar c) {
        if (LOG_FILE == null || CURRENT_DATE == null || PRINTWRITER == null || c.after(CURRENT_DATE) && (c.get(2) > CURRENT_DATE.get(2) || c.get(5) > CURRENT_DATE.get(5))) {
            CURRENT_DATE = c;
            if (PRINTWRITER != null) {
                try {
                    PRINTWRITER.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String createFileName = "hsf-" + LOG_FILE_FMT.format(c.getTime()) + ".dat";
            LOG_FILE = new File(LOG_DIR_PATH, createFileName);
            DeleteOutputStream os = new DeleteOutputStream(new AlivedFileOutputStream(LOG_FILE));
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            PRINTWRITER = new PrintWriter(osw);
        }
        return PRINTWRITER;
    }

    public static final void start() {
        if (STARTED.compareAndSet(false, true)) {
            Thread t = new Thread(TASK);
            t.setDaemon(true);
            t.setName("RTPrinter");
            THREAD = t;
            t.start();
        }
    }

    public static final void join() throws InterruptedException {
        if (null != THREAD && THREAD.isAlive()) {
            THREAD.join();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        RTPrinter.start();
        RTPrinter.join();
    }

    static {
        LOG_FILE_FMT = new SimpleDateFormat("yyyyMMdd");
        LOG_CONTENT_FMT = new SimpleDateFormat("yyyy/MM/dd_HH:mm:ss");
        TICK_NANO = TimeUnit.MILLISECONDS.toNanos(1000L);
        STARTED = new AtomicBoolean(false);
        TASK = new Runnable(){

            @Override
            public void run() {
                LOGGER.info("[RTPrinter] thraed start ");
                long deadline = System.nanoTime();
                while (true) {
                    try {
                        while (true) {
                            long now;
                            long snap;
                            if ((snap = (now = System.nanoTime()) - deadline) >= 0L) {
                                RTPrinter.write();
                                deadline = now + TICK_NANO;
                                LockSupport.parkNanos(TICK_NANO);
                                continue;
                            }
                            LockSupport.parkNanos(-snap);
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        };
        PROFILE_MAP = new ConcurrentHashMap();
        RTPrinter.start();
    }
}

