/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.serialize;

import com.taobao.hsf.log.LogService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public final class DataSizeMonitor {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final int DATA_SIZE_UPPER_LIMIT = 0x500000;
    private static final LogService logService = HSFServiceContainer.getInstance(LogService.class);

    public static void logRequestIn(int size) {
        try {
            DataSizeMonitor.log("RequestIn", size);
        }
        catch (Throwable t) {
            LOGGER.warn("[Data Size Monitor] logRequestIn error!", new Object[]{t});
        }
    }

    public static void logRequestOut(OutputStream outputStream) {
        try {
            int size = 0;
            if (outputStream instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteBuffer = (ByteArrayOutputStream)outputStream;
                size = byteBuffer.size();
            } else if (outputStream instanceof SliceOutputStream) {
                SliceOutputStream byteBuffer = (SliceOutputStream)outputStream;
                size = byteBuffer.size();
            } else {
                LOGGER.warn("[Data Size Monitor] logRequestOut error, Unknown output stream type: " + outputStream.getClass());
            }
            logService.requestSize(size);
            DataSizeMonitor.log("RequestOut", size);
        }
        catch (Throwable t) {
            LOGGER.warn("[Data Size Monitor] logRequestOut error!", new Object[]{t});
        }
    }

    public static void logResponseIn(InputStream inputStream) {
        try {
            int size = 0;
            if (inputStream instanceof ByteArrayInputStream) {
                ByteArrayInputStream byteBuffer = (ByteArrayInputStream)inputStream;
                size = byteBuffer.available();
            } else {
                LOGGER.warn("[Data Size Monitor] logResponseIn error, Unknown input stream type: " + inputStream.getClass());
            }
            logService.requestSize(size);
            DataSizeMonitor.log("ResponseIn", size);
        }
        catch (Throwable t) {
            LOGGER.warn("[Data Size Monitor] logResponseIn error!", new Object[]{t});
        }
    }

    public static void logResponseOut(ByteArrayOutputStream outputStream) {
        try {
            int size = outputStream.size();
            logService.requestSize(size);
            DataSizeMonitor.log("ResponseOut", size);
        }
        catch (Throwable t) {
            LOGGER.warn("[Data Size Monitor] logResponseOut error!", new Object[]{t});
        }
    }

    private static void log(String tag, int size) {
        if (0x500000 <= size) {
            LOGGER.warn(MessageFormat.format("[Data Size Monitor] Upper Limit [{0}], please check EagleEye Log for details", tag));
        }
    }
}

