/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.serialize;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.serialize.NamedCustomSerialization;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.DefaultSerialization;
import com.taobao.remoting.serialize.SerializationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HSFRequestSerialization
implements NamedCustomSerialization<HSFRequest> {
    private static final Logger LOGGER = LoggerInit.LOGGER;

    public HSFRequest deserialize(InputStream inputStream, byte protocol) throws IOException {
        HSFRequest request = null;
        if (1 == protocol || 4 == protocol) {
            HessianInput hessianInput = DefaultSerialization.createHessianInput((InputStream)inputStream);
            request = (HSFRequest)hessianInput.readObject();
            String[] sig = request.getMethodArgSigs();
            Object[] args = new Object[sig.length];
            Class[] classSig = new Class[sig.length];
            try {
                for (int x = 0; x < sig.length; ++x) {
                    Class<?> signature = this.getPrimitiveType(sig[x]);
                    classSig[x] = signature != null ? signature : Class.forName(sig[x]);
                }
                for (int i = 0; i < request.getMethodArgSigs().length; ++i) {
                    args[i] = hessianInput.readObject(classSig[i]);
                }
            }
            catch (Throwable e) {
                LOGGER.warn("\u4f7f\u7528Hessian\u53cd\u5e8f\u5217\u5316\u65f6\u5019\u51fa\u95ee\u9898", new Object[]{e});
                throw new IOException(e);
            }
            request.setMethodArgs(args);
        } else if (2 == protocol || 3 == protocol) {
            CustomSerialization serialize = SerializationUtil.getDefaultSerialization();
            request = (HSFRequest)serialize.deserialize(inputStream, protocol);
            Object[] args = new Object[request.getMethodArgSigs().length];
            for (int i = 0; i < request.getMethodArgSigs().length; ++i) {
                args[i] = serialize.deserialize(inputStream, protocol);
            }
            request.setMethodArgs(args);
        } else {
            throw new IllegalArgumentException("\u4e0d\u53ef\u8bc6\u522b\u7684\u5e8f\u5217\u5316\u534f\u8bae: " + protocol);
        }
        return request;
    }

    public void serialize(HSFRequest hsfRequest, byte protocol, OutputStream outputStream) throws IOException {
        block4: {
            block3: {
                if (1 != protocol && 4 != protocol) break block3;
                HessianOutput hessianOutput = DefaultSerialization.createHessianOutput((OutputStream)outputStream);
                hessianOutput.writeObject((Object)hsfRequest);
                Object[] args = hsfRequest.getMethodArgs();
                if (args == null) break block4;
                for (int i = 0; i < args.length; ++i) {
                    hessianOutput.writeObject(args[i]);
                }
                break block4;
            }
            CustomSerialization serialize = SerializationUtil.getDefaultSerialization();
            serialize.serialize((Object)hsfRequest, protocol, outputStream);
            Object[] args = hsfRequest.getMethodArgs();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    serialize.serialize(args[i], protocol, outputStream);
                }
            }
        }
    }

    private Class<?> getPrimitiveType(String name) {
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    @Override
    public String getName() {
        return HSFRequest.class.getName();
    }
}

