/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.service;

import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.diagnostic.Profiler;
import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.InvokerContext;
import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.address.unit.UnitAddressService;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFServiceAddressNotFoundException;
import com.taobao.hsf.exception.HSFTimeOutException;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerMethodModel;
import com.taobao.hsf.model.ProviderMethodModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.monitor.service.MonitorService;
import com.taobao.hsf.plugins.octopus.HSFMockResult;
import com.taobao.hsf.plugins.octopus.MockHookService;
import com.taobao.hsf.remoting.RemotingRuntimeInfoHolder;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.invoke.component.CallbackInvokeComponent;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.hsf.remoting.service.RPCProtocolService;
import com.taobao.hsf.remoting.service.RPCProtocolTemplateService;
import com.taobao.hsf.scm.ScmAddressSelectService;
import com.taobao.hsf.tbremoting.invoke.CallbackInvocationContext;
import com.taobao.hsf.tbremoting.invoke.HSFResponseCallback;
import com.taobao.hsf.tbremoting.invoke.HSFResponseFuture;
import com.taobao.hsf.tbremoting.invoke.RemotingResponseFuture;
import com.taobao.hsf.unit.service.UnitService;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.hsf.util.PojoUtils;
import com.taobao.hsf.util.ReflectUtils;
import com.taobao.hsf.util.ThreadLocalUtil;
import com.taobao.hsf.util.ThreadPoolUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.spas.sdk.client.SpasSdkClientFacade;
import com.taobao.spas.sdk.client.identity.Credentials;
import com.taobao.spas.sdk.common.sign.SpasSigner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class RPCProtocolTemplateComponent
implements RPCProtocolTemplateService {
    private static final String TXC_XID = "TXC_XID";
    private static final String ENABLE_TXC = "EnableTXC";
    private static final String PSEUDO = "pseudo";
    private static final String HSF_CONSUMER_ACTIVE_THREAD = "HSF-Consumer-ActiveThread";
    private static final String EAGLEEYE_CONTEXT = "eagleeye_context";
    private static final String TARGET = "target";
    private static final String ERROR_MSG_FORMATTOR = "RPC\u534f\u8bae\u8c03\u7528\u670d\u52a1[{0}]\u7684[{1}]\u65b9\u6cd5\u65f6\u51fa\u73b0\u9519\u8bef\uff1a\n\u6240\u8c03\u7528\u7684\u670d\u52a1\u76ee\u6807\u5730\u5740\u4e3a\uff1a[{2}]\n TraceId={3},\n, RpcId={4}\n";
    private static final String ERROR_MSG_FORMATTOR_TIMEOUT = "RPC\u534f\u8bae\u8c03\u7528\u670d\u52a1[{0}]\u7684[{1}]\u65b9\u6cd5\u65f6\u51fa\u73b0\u9519\u8bef\uff1a\n\u6240\u8c03\u7528\u7684\u670d\u52a1\u76ee\u6807\u5730\u5740\u4e3a\uff1a[{2}]\n\u9519\u8bef\u539f\u56e0\u4e3a\u8d85\u65f6\uff0c\u8bf7\u67e5\u770b\u670d\u52a1\u5668\u7aef\u7684\u6267\u884c\u65e5\u5fd7\u662f\u5426\u4e5f\u8d85\u65f6\uff0c\u6267\u884c\u65f6\u95f4\u4e3a\uff1a{3}ms. TraceId={4},\n, RpcId={5}\n";
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final int RETRY_TIMES = 10;
    private final AddressService addressService = HSFServiceContainer.getInstance(AddressService.class);
    private final UnitAddressService unitAddressService = HSFServiceContainer.getInstance(UnitAddressService.class);
    private final ConfigurationService configService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private final RPCProtocolService rpcService = HSFServiceContainer.getInstance(RPCProtocolService.class);
    private final MonitorService monitorService = HSFServiceContainer.getInstance(MonitorService.class);
    private final NettyClientFactory clientFactory = NettyClientFactory.getInstance();
    private final UnitService unitService = HSFServiceContainer.getInstance(UnitService.class);
    private final ApplicationModel applicationModel = ApplicationModel.instance();
    private final ScmAddressSelectService scmAddressSelectService = HSFServiceContainer.getInstance(ScmAddressSelectService.class);
    private final MockHookService mockHookService = HSFServiceContainer.getInstance(MockHookService.class);
    private final LogService logService = HSFServiceContainer.getInstance(LogService.class);

    @Override
    public Object invokeWithMethodInfos(ServiceMetadata metadata, String methodName, String[] parameterTypes, Object[] args) throws Throwable {
        long beginTime = System.currentTimeMillis();
        String serviceName = metadata.getUniqueName();
        args = null == args ? new Object[]{} : args;
        ConsumerMethodModel methodModel = new ConsumerMethodModel(methodName, parameterTypes, metadata);
        boolean isBizStartProfile = null != Profiler.getEntry();
        boolean isCallBack = methodModel.isCallBackMethod();
        InvokerContext invokerContext = new InvokerContext();
        Object uid = ThreadLocalUtil.remove("_hsf_unit_deploy_user_id");
        if (uid != null) {
            invokerContext.setUserId((Long)uid);
        }
        Throwable throwable = null;
        try {
            if (isBizStartProfile) {
                Profiler.enter((String)methodModel.getEnterMsg());
            } else {
                Profiler.start((String)methodModel.getEnterMsg());
            }
            Object rs = this.invoke0(methodModel, args, invokerContext);
            if (!isCallBack) {
                this.logService.rpcClientRecvSuccess();
            }
            Object object = rs;
            return object;
        }
        catch (Throwable t) {
            throwable = t;
            String errorMsg = null;
            errorMsg = t.getCause() instanceof HSFTimeOutException ? MessageFormat.format(ERROR_MSG_FORMATTOR_TIMEOUT, serviceName, methodName, invokerContext.getRemotingURL(), System.currentTimeMillis() - beginTime, this.logService.getTraceId(), this.logService.getRpcId()) : MessageFormat.format(ERROR_MSG_FORMATTOR, serviceName, methodName, invokerContext.getRemotingURL(), this.logService.getTraceId(), this.logService.getRpcId());
            LOGGER.warn(errorMsg, new Object[]{t});
            if (!isCallBack) {
                if (t.getCause() instanceof HSFTimeOutException) {
                    this.logService.rpcClientRecv("03");
                } else if (t.getCause() instanceof HSFException) {
                    this.logService.rpcClientRecv("02");
                } else {
                    this.logService.rpcClientRecvFailed();
                }
            }
            throw t;
        }
        finally {
            this.addMonitorLog(PSEUDO, metadata, methodName, throwable, System.currentTimeMillis() - beginTime);
            if (isBizStartProfile) {
                Profiler.release();
            } else {
                Profiler.reset();
            }
        }
    }

    @Override
    public Object invokeWithMethodObject(ConsumerMethodModel methodModel, Object[] args) throws HSFException, Throwable {
        long beginTime = System.currentTimeMillis();
        String serviceName = methodModel.getUniqueName();
        args = null == args ? new Object[]{} : args;
        boolean isBizStartProfile = null != Profiler.getEntry();
        boolean isCallBack = methodModel.isCallBackMethod();
        Object rs = null;
        Throwable throwable = null;
        InvokerContext invokerContext = new InvokerContext();
        Object uid = ThreadLocalUtil.remove("_hsf_unit_deploy_user_id");
        if (uid != null) {
            invokerContext.setUserId((Long)uid);
        }
        try {
            if (isBizStartProfile) {
                Profiler.enter((String)methodModel.getEnterMsg());
            } else {
                Profiler.start((String)methodModel.getEnterMsg());
            }
            rs = this.invoke0(methodModel, args, invokerContext);
            if (!isCallBack) {
                this.logService.rpcClientRecvSuccess();
            }
            Object object = rs;
            return object;
        }
        catch (Throwable t) {
            throwable = t;
            String errorMsg = null;
            String methodName = methodModel.getMethodName();
            errorMsg = t.getCause() instanceof HSFTimeOutException ? MessageFormat.format(ERROR_MSG_FORMATTOR_TIMEOUT, serviceName, methodName, invokerContext.getRemotingURL(), System.currentTimeMillis() - beginTime, this.logService.getTraceId(), this.logService.getRpcId()) : MessageFormat.format(ERROR_MSG_FORMATTOR, serviceName, methodName, invokerContext.getRemotingURL(), this.logService.getTraceId(), this.logService.getRpcId());
            LOGGER.warn(errorMsg, new Object[]{t});
            if (!isCallBack) {
                if (t.getCause() instanceof HSFTimeOutException) {
                    this.logService.rpcClientRecv("03");
                } else if (t.getCause() instanceof HSFException) {
                    this.logService.rpcClientRecv("02");
                } else {
                    this.logService.rpcClientRecvFailed();
                }
            }
            throw t;
        }
        finally {
            if (RemotingRuntimeInfoHolder.getInstance().isCountConsumer()) {
                RemotingRuntimeInfoHolder.getInstance().addConsumer(methodModel.getMethodName(), serviceName, args, rs, System.currentTimeMillis() - beginTime);
            }
            this.addMonitorLog(PSEUDO, methodModel.getMetadata(), methodModel.getMethodName(), throwable, System.currentTimeMillis() - beginTime);
            invokerContext = null;
            if (isBizStartProfile) {
                Profiler.release();
            } else {
                Profiler.reset();
            }
        }
    }

    @Override
    public void registerProvider(ServiceMetadata metadata) throws HSFException {
        this.rpcService.registerProvider(metadata);
    }

    private Object invoke0(ConsumerMethodModel methodModel, Object[] args, InvokerContext invokerContext) throws HSFException, Throwable {
        String octopus;
        HSFMockResult result;
        String serviceUniqueName = methodModel.getUniqueName();
        String methodName = methodModel.getMethodName();
        this.monitorService.add(HSF_CONSUMER_ACTIVE_THREAD, serviceUniqueName, methodName, 1L, 1L);
        String[] parameterTypes = methodModel.getParameterTypes();
        HSFRequest request = new HSFRequest();
        request.setTargetServiceUniqueName(serviceUniqueName);
        request.setMethodName(methodName);
        request.setMethodArgSigs(parameterTypes);
        request.setMethodArgs(args);
        request.setReturnClass(methodModel.getReturnClass());
        request.setParameterClasses(methodModel.getParameterClasses());
        ServiceMetadata metadata = methodModel.getMetadata();
        if (invokerContext.getUserId() != null) {
            request.setRequestProps("_hsf_unit_deploy_user_id", (long)invokerContext.getUserId());
        }
        if (this.isLocalInvoke(methodModel.getMetadata(), request, invokerContext)) {
            return this.localInvoke(methodModel, serviceUniqueName, methodName, request, metadata);
        }
        request.setRequestProps("Consumer-AppName", AppInfoUtils.getAppName());
        String secureKey = methodModel.getSecureKey();
        if (StringUtil.isNotEmpty((String)secureKey)) {
            request.setRequestProps("Secure-Key", secureKey);
        }
        try {
            String secretKey;
            Credentials credential = SpasSdkClientFacade.getCredential();
            String string = secretKey = credential == null ? null : credential.getSecretKey();
            if (StringUtil.isNotEmpty((String)secretKey)) {
                String version;
                String accessKey;
                long timestamp = System.currentTimeMillis();
                request.setRequestProps("Time-Stamp", timestamp);
                String signature = SpasSigner.sign((String)String.valueOf((Object)timestamp), (String)secretKey);
                request.setRequestProps("Spas-Signature", signature);
                String string2 = accessKey = credential == null ? null : credential.getAccessKey();
                if (StringUtil.isNotEmpty((String)accessKey)) {
                    request.setRequestProps("Access-Key", accessKey);
                }
                if (StringUtil.isNotEmpty((String)(version = SpasSdkClientFacade.getVersion()))) {
                    request.setRequestProps("Spas-Version", version);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", "spas init error", (Throwable)e);
        }
        this.logService.startRpc(serviceUniqueName, methodModel.getMethodNameToLog());
        Object rpcCtx = this.logService.currentRpcContext();
        if (null != rpcCtx) {
            request.setRequestProps(EAGLEEYE_CONTEXT, rpcCtx);
        }
        if (this.mockHookService != null && (result = this.mockHookService.beforeInvoke(octopus = this.logService.getUserData("octopus"), methodModel.getMethod(), serviceUniqueName, methodName, parameterTypes)) != null && result.isValidMock()) {
            Object appResponse = result.getMockValue();
            if (appResponse instanceof Throwable) {
                throw (Throwable)appResponse;
            }
            return appResponse;
        }
        int retryTime = 0;
        int executeTimes = methodModel.getExecuteTimes();
        String targetServerIp = (String)ThreadLocalUtil.remove("_hsf_target_server_ip");
        Object appResponse = null;
        RemotingURL remotingURL = null;
        while (true) {
            String targetURLString;
            ++retryTime;
            String targetUnit = this.getTargetUnit(metadata, args, invokerContext);
            if (metadata.getServiceProperties().get(TARGET) != null) {
                targetURLString = metadata.getServiceProperties().get(TARGET);
                remotingURL = RemotingURL.valueOf(targetURLString, metadata.getConnectionIndex());
            } else if (targetServerIp != null) {
                targetURLString = this.addressService.getAddressByIp(serviceUniqueName, targetServerIp);
                remotingURL = this.validTarget(targetURLString, metadata.getConnectionIndex());
                if (remotingURL == null) {
                    throw new HSFException("user specified server [" + targetServerIp + "] is invalid");
                }
            } else {
                remotingURL = this.scmAddressSelectService != null ? this.selectScmAddress(request, targetUnit, serviceUniqueName, metadata, methodName, parameterTypes, args) : this.selectAddress(targetUnit, metadata, serviceUniqueName, methodName, parameterTypes, args);
            }
            if (remotingURL == null) {
                throw new HSFServiceAddressNotFoundException("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0001", (String)"Env-Problem", (String)("[HSF-Consumer] \u672a\u627e\u5230\u9700\u8981\u8c03\u7528\u7684\u670d\u52a1\u7684\u76ee\u6807\u5730\u5740, \u9700\u8981\u8c03\u7528\u7684\u76ee\u6807\u670d\u52a1\u4e3a\uff1a" + serviceUniqueName + " \u7ec4\u522b\u4e3a\uff1a" + metadata.getGroup())));
            }
            invokerContext.setRemotingURL(remotingURL);
            String remoteIp = remotingURL.getHost();
            this.logService.remoteIp(remoteIp);
            try {
                appResponse = this.rpcService.invoke(request, methodModel, remotingURL);
            }
            catch (HSFTimeOutException e) {
                if (retryTime < executeTimes) continue;
                throw e;
            }
            break;
        }
        this.monitorService.add(HSF_CONSUMER_ACTIVE_THREAD, serviceUniqueName, methodName, -1L, -1L);
        if (appResponse instanceof Throwable) {
            throw (Throwable)appResponse;
        }
        return appResponse;
    }

    private Object localInvoke(ConsumerMethodModel methodModel, String serviceUniqueName, String methodName, HSFRequest request, ServiceMetadata metadata) throws HSFException, Throwable {
        this.logService.startRpc(serviceUniqueName, methodModel.getMethodNameToLog());
        Object appResponse = this.localInvoke(request, serviceUniqueName);
        if (methodModel.isAsyncMethod() || "FUTURE".equalsIgnoreCase(ThreadLocalUtil.getInvokeType())) {
            final HSFResponse hsfResponse = new HSFResponse();
            hsfResponse.setAppResponse(appResponse);
            ServiceMetadata.AsyncallMethod funcDesc = metadata.getAsyncallMethod(methodName);
            if (methodModel.isFutureMethod() || "FUTURE".equalsIgnoreCase(ThreadLocalUtil.getInvokeType())) {
                ThreadLocalUtil.clearInvokeTypeSet();
                RemotingResponseFuture rf = new RemotingResponseFuture(hsfResponse);
                if (metadata.getConfigStyle() == EnumConfigStyle.HSF) {
                    HSFResponseFuture.setFuture(rf);
                }
            } else {
                Object obj;
                this.logService.popRpcContext();
                HSFResponseCallback bizCallback = (HSFResponseCallback)funcDesc.getCallbackInstance();
                if (bizCallback == null && (obj = metadata.getCallbackInvoker()) instanceof HSFResponseCallback) {
                    bizCallback = (HSFResponseCallback)obj;
                }
                final CallbackInvokeComponent.HSFCallBackListener listener = new CallbackInvokeComponent.HSFCallBackListener(bizCallback, this.logService.getRpcContext(), CallbackInvocationContext.getContext());
                ThreadPoolExecutor executor = ThreadPoolUtil.getThreadPoolManager().getDefaultPoolExecutor();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResponse(hsfResponse);
                    }
                });
            }
            if (request.getReturnClass() == null) {
                return null;
            }
            return ReflectUtils.defaultReturn(request.getReturnClass());
        }
        if (appResponse instanceof Throwable) {
            throw (Throwable)appResponse;
        }
        return appResponse;
    }

    private boolean isLocalInvoke(ServiceMetadata metadata, HSFRequest request, InvokerContext invokerContext) {
        if (this.configService.isLocalCallEnable() && null != this.applicationModel.getProvidedServiceModel(metadata.getUniqueName())) {
            if (this.unitService != null) {
                return this.unitService.isUnitLocalInvoke(metadata, request, invokerContext);
            }
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private Object localInvoke(HSFRequest request, String serviceUniqueName) throws HSFException {
        Object object;
        block15: {
            String oldTXC_XID = null;
            try {
                ProviderServiceModel serviceModel = this.applicationModel.getProvidedServiceModel(serviceUniqueName);
                if (serviceModel.getMetadata().isEnableTXC()) {
                    this.logService.attribute(ENABLE_TXC, "true");
                } else {
                    this.logService.attribute(ENABLE_TXC, null);
                    oldTXC_XID = this.logService.removeUserData(TXC_XID);
                }
                boolean isGeneric = false;
                String methodName = request.getMethodName();
                String[] sigs = request.getMethodArgSigs();
                Object[] args = request.getMethodArgs();
                if (methodName.equals("$invoke") && sigs != null && sigs.length == 3) {
                    Object[] methodArgs = request.getMethodArgs();
                    methodName = ((String)methodArgs[0]).trim();
                    sigs = (String[])methodArgs[1];
                    for (int i = 0; i < sigs.length; ++i) {
                        try {
                            sigs[i] = ReflectUtils.name2class(sigs[i]).getName();
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    args = (Object[])methodArgs[2];
                    isGeneric = true;
                }
                Object localService = serviceModel.getServiceInstance();
                ProviderMethodModel methodModel = serviceModel.getMethodModel(methodName, sigs);
                if (methodModel == null) {
                    throw new NoSuchMethodException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0030", (String)"Biz-Problem", (String)("\u672a\u627e\u5230\u9700\u8981\u8c03\u7528\u7684\u65b9\u6cd5\uff1a" + methodName + "\uff1b\u670d\u52a1\u540d\u4e3a\uff1a" + serviceUniqueName)));
                }
                Method appServiceMethod = methodModel.getMethod();
                this.logService.remoteIp(InetAddressUtil.getIP());
                this.logService.rpcClientSend();
                Object appResponse = appServiceMethod.invoke(localService, args);
                Object object2 = object = isGeneric ? PojoUtils.generalize(appResponse) : appResponse;
                if (oldTXC_XID == null) break block15;
                this.logService.putUserData(TXC_XID, oldTXC_XID);
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getTargetException();
                return throwable;
            }
            catch (Exception e2) {
                throw new HSFException("\u8c03\u7528\u672c\u5730HSF\u670d\u52a1\u51fa\u73b0\u9519\u8bef\uff1a", e2);
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                if (oldTXC_XID != null) {
                    this.logService.putUserData(TXC_XID, oldTXC_XID);
                }
            }
        }
        return object;
    }

    private String getTargetUnit(ServiceMetadata metadata, Object[] args, InvokerContext invokerContext) throws HSFException {
        String targetUnit = (String)ThreadLocalUtil.get("target-unit");
        if (targetUnit != null) {
            ThreadLocalUtil.remove("target-unit");
            return targetUnit;
        }
        if (this.unitService != null) {
            return this.unitService.getTargetUnit(metadata, args, invokerContext);
        }
        return null;
    }

    private RemotingURL selectScmAddress(HSFRequest request, String targetUnit, String serviceUniqueName, ServiceMetadata metadata, String methodName, String[] paramTypeStrs, Object[] args) throws HSFException {
        String targetURL = null;
        if (this.scmAddressSelectService != null) {
            List<String> addressFiltered = null;
            if (this.unitService != null && this.unitAddressService != null && this.unitService.isUnitModel()) {
                if (metadata.getWriteMode() == null) {
                    if (targetUnit == null) {
                        addressFiltered = this.addressService.getServiceAddressFiltered(serviceUniqueName, methodName, paramTypeStrs, args);
                    } else {
                        addressFiltered = this.unitAddressService.getServiceAddressFiltered(targetUnit, serviceUniqueName, methodName, paramTypeStrs, args);
                        if (addressFiltered == null || addressFiltered.isEmpty()) {
                            addressFiltered = this.addressService.getServiceAddressFiltered(serviceUniqueName, methodName, paramTypeStrs, args);
                        }
                    }
                } else {
                    addressFiltered = targetUnit == null ? this.addressService.getServiceAddressFiltered(serviceUniqueName, methodName, paramTypeStrs, args) : this.unitAddressService.getServiceAddressFiltered(targetUnit, serviceUniqueName, methodName, paramTypeStrs, args);
                }
            } else {
                addressFiltered = this.addressService.getServiceAddressFiltered(serviceUniqueName, methodName, paramTypeStrs, args);
            }
            try {
                targetURL = this.scmAddressSelectService.selectAddress(request, addressFiltered, this.rpcService, metadata, serviceUniqueName, methodName, paramTypeStrs, args);
            }
            catch (HSFServiceAddressNotFoundException e) {
                List<String> csAddress = this.addressService.getServiceAddresses(serviceUniqueName);
                if (csAddress == null || csAddress.isEmpty()) {
                    this.logService.attribute("h", "1");
                } else if (addressFiltered.isEmpty()) {
                    this.logService.attribute("h", "2");
                } else {
                    this.logService.attribute("h", "3");
                }
                throw e;
            }
        }
        return RemotingURL.valueOf(targetURL, metadata.getConnectionIndex());
    }

    private RemotingURL selectAddress(String targetUnit, ServiceMetadata metadata, String serviceUniqueName, String methodName, String[] paramTypeStrs, Object[] args) {
        RemotingURL targetURL = null;
        if (this.unitService != null && this.unitAddressService != null && this.unitService.isUnitModel()) {
            if (metadata.getWriteMode() == null) {
                if (targetUnit == null) {
                    targetURL = this.selectAndValidateAddress(serviceUniqueName, methodName, paramTypeStrs, args, metadata.getConnectionIndex());
                } else {
                    targetURL = this.selectAndValidateUnitAddress(targetUnit, serviceUniqueName, methodName, paramTypeStrs, args, metadata.getConnectionIndex());
                    if (targetURL == null) {
                        targetURL = this.selectAndValidateAddress(serviceUniqueName, methodName, paramTypeStrs, args, metadata.getConnectionIndex());
                    }
                }
            } else {
                targetURL = targetUnit == null ? this.selectAndValidateAddress(serviceUniqueName, methodName, paramTypeStrs, args, metadata.getConnectionIndex()) : this.selectAndValidateUnitAddress(targetUnit, serviceUniqueName, methodName, paramTypeStrs, args, metadata.getConnectionIndex());
            }
        } else {
            targetURL = this.selectAndValidateAddress(serviceUniqueName, methodName, paramTypeStrs, args, metadata.getConnectionIndex());
        }
        return targetURL;
    }

    private RemotingURL selectAndValidateAddress(String serviceUniqueName, String methodName, String[] paramTypeStrs, Object[] args, int connIndex) {
        for (int i = 0; i < 10; ++i) {
            String targetURL = this.addressService.getServiceAddress(serviceUniqueName, methodName, paramTypeStrs, args);
            if (targetURL == null) continue;
            RemotingURL url = this.validTarget(targetURL, connIndex);
            if (url == null) {
                if (targetURL.length() <= 0) continue;
                LOGGER.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0035", (String)"Biz-Problem", (String)("RPCProtocolTemplateComponent invalid address\uff1a" + targetURL)));
                this.addressService.invalidateAddress(serviceUniqueName, targetURL);
                continue;
            }
            return url;
        }
        return null;
    }

    private RemotingURL validTarget(String targetURL, int connIndex) {
        try {
            RemotingURL url = RemotingURL.valueOf(targetURL, connIndex);
            return this.clientFactory.get(url) != null ? url : null;
        }
        catch (Exception e) {
            LOGGER.debug("wrong validate URL:", new Object[]{e});
            return null;
        }
    }

    private void addMonitorLog(String bizCaller, ServiceMetadata metadata, String methodName, Throwable throwable, long durationMs) {
        String statAppName = null;
        statAppName = null == throwable ? "HSF-Consumer" : (!(throwable instanceof HSFException) ? "HSF-Consumer-BizException" : (null != throwable.getCause() && throwable.getCause() instanceof HSFTimeOutException ? "HSF-Consumer-Timeout" : "HSF-Consumer-Exception"));
        this.monitorService.add(statAppName, metadata.getUniqueName(), methodName, bizCaller, 1L, durationMs);
    }

    private RemotingURL selectAndValidateUnitAddress(String unit, String serviceUniqueName, String methodName, String[] paramTypeStrs, Object[] args, int connIndex) {
        for (int i = 0; i < 10; ++i) {
            String targetURL = this.unitAddressService.getServiceAddress(unit, serviceUniqueName, methodName, paramTypeStrs, args);
            if (targetURL == null) continue;
            RemotingURL url = this.validTarget(targetURL, connIndex);
            if (url == null) {
                LOGGER.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0035", (String)"Biz-Problem", (String)("RPCProtocolTemplateComponent invalid address\uff1a" + targetURL)));
                this.addressService.invalidateAddress(serviceUniqueName, targetURL);
                continue;
            }
            return url;
        }
        return null;
    }
}

