/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.route.component;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AppAddressFilterManager {
    private static final Logger log = LoggerInit.LOGGER;
    private static final String config_file_name = "addressfilter.properties";
    private static final String filter_method_name = "filterAddress";
    private static final Class<?>[] filter_method_parameter_types = new Class[]{List.class, String.class, String.class, String[].class, Object[].class};
    public static final AppAddressFilterManager instance = new AppAddressFilterManager();
    private volatile Map<String, AppAddressFilter> filters = new HashMap<String, AppAddressFilter>();

    private AppAddressFilterManager() {
        ClassLoader cl = AppAddressFilterManager.class.getClassLoader();
        InputStream in = cl.getResourceAsStream(config_file_name);
        if (in == null) {
            log.info("No addressfilter.properties found in classpath.");
            return;
        }
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            log.error("", "Load addressfilter.properties failed.", (Throwable)e);
            return;
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String serviceName = (String)entry.getKey();
            String className = (String)entry.getValue();
            this.addFilter(serviceName, className);
        }
    }

    public synchronized void addFilter(String serviceName, String className) {
        HashMap<String, AppAddressFilter> newFilters = new HashMap<String, AppAddressFilter>();
        newFilters.putAll(this.filters);
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            Method filterMethod = clazz.getMethod(filter_method_name, filter_method_parameter_types);
            if (List.class.isAssignableFrom(filterMethod.getReturnType())) {
                newFilters.put(serviceName, new AppAddressFilter(obj, filterMethod));
            } else {
                log.warn("filterAddress() not return List. className:" + className + ",ReturnType:" + filterMethod.getReturnType());
            }
        }
        catch (Exception e) {
            log.error("", "Init filter class failed. className:" + className, (Throwable)e);
            return;
        }
        this.filters = newFilters;
        log.info(serviceName + "'s filter class loaded:" + className);
    }

    boolean hasFilter(String serviceName) {
        return this.filters.containsKey(serviceName);
    }

    public List<String> filterAddress(List<String> serviceAddressList, String serviceName, String methodName, String[] paramTypeStrs, Object[] args) {
        log.debug("[filterAddress]serviceName=" + serviceName);
        if (this.filters.get(serviceName) == null) {
            return serviceAddressList;
        }
        try {
            AppAddressFilter filter = this.filters.get(serviceName);
            return (List)filter.m.invoke(filter.obj, serviceAddressList, serviceName, methodName, paramTypeStrs, args);
        }
        catch (Exception e) {
            log.warn("Invoke app address filter failed.servicName:" + serviceName, new Object[]{e});
            return serviceAddressList;
        }
    }

    private static class AppAddressFilter {
        public final Object obj;
        public final Method m;

        public AppAddressFilter(Object obj, Method m) {
            this.obj = obj;
            this.m = m;
        }
    }
}

