/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.route.strategy.methodname;

import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.route.service.RouteRuleParser;
import com.taobao.hsf.route.service.RouteRuleParserException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodNameRouteRuleParser
implements RouteRuleParser {
    private static String getMethodName(String m) {
        String[] methodSigs = m.split("#");
        return methodSigs[0];
    }

    @Override
    public RouteRule parse(Object rawRouteRuleObj, List<String> methodSigs) throws RouteRuleParserException {
        Map methodRouteInfos;
        if (!Map.class.isAssignableFrom(rawRouteRuleObj.getClass())) {
            return null;
        }
        try {
            methodRouteInfos = (Map)rawRouteRuleObj;
        }
        catch (ClassCastException e) {
            return null;
        }
        RouteRule rr = new RouteRule();
        rr.setKeyedRules(methodRouteInfos);
        HashMap<String, Object> methodRule = new HashMap<String, Object>();
        for (String m : methodSigs) {
            String methodName = MethodNameRouteRuleParser.getMethodName(m);
            if (!methodRouteInfos.containsKey(methodName)) continue;
            methodRule.put(m, methodName);
        }
        rr.setMethodRule(methodRule);
        return rr;
    }
}

