/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.rpc.provider.async;

import com.alibaba.common.lang.diagnostic.Profiler;
import com.taobao.hsf.ServiceInvokeTransform;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ProviderMethodModel;
import com.taobao.hsf.monitor.service.MonitorService;
import com.taobao.hsf.remoting.server.output.ServerOutput;
import com.taobao.hsf.util.CutCauseUtil;
import com.taobao.hsf.util.PojoUtils;
import com.taobao.hsf.util.ThreadLocalUtil;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncContext {
    public static final String KEY_ASYNC_STARTED = "_hsf_aysnc_started";
    public static final String KEY_ASYNC_CONTEXT = "_hsf_async_context";
    private static Logger LOGGER = LoggerInit.LOGGER;
    private final MonitorService monitorService;
    private final LogService eagleEyeLogService;
    private final ServerOutput output;
    private final HSFRequest hsfRequest;
    private final ProviderMethodModel methodModel;
    private final boolean isGeneric;
    private final Object[] originalArgs;
    private final String[] originalArgTypes;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String reason;
    private Throwable reasonThrowable;
    private final long beginTime = System.currentTimeMillis();

    public AsyncContext(MonitorService monitorService, LogService eagleEyeLogService, ServerOutput output, HSFRequest hsfRequest, Object[] originalArgs, String[] originalArgTypes, boolean isGeneric, ProviderMethodModel methodModel) {
        this.monitorService = monitorService;
        this.eagleEyeLogService = eagleEyeLogService;
        this.output = output;
        this.hsfRequest = hsfRequest;
        this.originalArgs = originalArgs;
        this.isGeneric = isGeneric;
        this.originalArgTypes = originalArgTypes;
        this.methodModel = methodModel;
    }

    public void write(Object appResp) {
        if (!this.closeAsync("Response already written", null)) {
            throw new IllegalStateException("AsyncContext already closed : " + this.reason, this.reasonThrowable);
        }
        if (appResp instanceof Throwable) {
            this.serverLogError((Throwable)appResp);
            CutCauseUtil.cutCause((Throwable)appResp);
            this.serverHaboLog(true);
        } else {
            this.serverHaboLog(false);
        }
        HSFResponse hsfResponse = new HSFResponse();
        if (this.isGeneric) {
            appResp = PojoUtils.generalize(appResp);
        }
        hsfResponse.setAppResponse(appResp);
        if (3 == this.hsfRequest.getSerializeType()) {
            String serviceUniqueName = this.hsfRequest.getTargetServiceUniqueName();
            ServiceInvokeTransform transform = ServiceInvokeTransform.Helper.find(serviceUniqueName);
            try {
                hsfResponse.setAppResponse(transform.transformResponse(this.hsfRequest.getMethodName(), this.originalArgs, this.originalArgTypes, hsfResponse.getAppResponse()));
            }
            catch (Exception e) {
                hsfResponse.setErrorType("TOP3");
                hsfResponse.setErrorMsg("TOP\u5728\u5bf9\u670d\u52a1[" + serviceUniqueName + "]\u7684\u8fd4\u56de\u7ed3\u679c\u8fdb\u884c\u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\u3002" + e.getMessage());
            }
        }
        if (hsfResponse.isError()) {
            String type = hsfResponse.getErrorType();
            if (type == null) {
                type = "Unknown";
            }
            this.eagleEyeLogService.rpcServerSend("02", type);
        } else if (hsfResponse.getAppResponse() instanceof Throwable) {
            this.eagleEyeLogService.rpcServerSendFailed(hsfResponse.getAppResponse().getClass().getSimpleName());
        } else {
            this.eagleEyeLogService.rpcServerSendSuccess();
        }
        this.output.writeHSFResponse(hsfResponse);
    }

    public boolean closeAsync(String reason, Throwable t) {
        if (this.closed.compareAndSet(false, true)) {
            this.reason = reason;
            this.reasonThrowable = t;
            return true;
        }
        return false;
    }

    public static AsyncContext startAsync() {
        ThreadLocalUtil.set(KEY_ASYNC_STARTED, Boolean.TRUE);
        return (AsyncContext)ThreadLocalUtil.get(KEY_ASYNC_CONTEXT);
    }

    private void serverLogError(Throwable t) {
        StringBuilder errBuilder = new StringBuilder();
        errBuilder.append("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[");
        errBuilder.append(this.hsfRequest.getTargetServiceUniqueName());
        errBuilder.append("]\u7684\u65b9\u6cd5[");
        errBuilder.append(this.hsfRequest.getMethodName());
        errBuilder.append("]\u65f6\u51fa\u73b0\u4e1a\u52a1\u5f02\u5e38\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[");
        errBuilder.append(this.output.getConnection().getPeerIP());
        errBuilder.append("]\uff0c\u6267\u884c\u7684\u53c2\u6570\u4e3a\uff1a[");
        Object[] methodArgs = this.hsfRequest.getMethodArgs();
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                errBuilder.append(methodArgs[i]);
                errBuilder.append(",");
            }
        }
        errBuilder.append("]\n");
        errBuilder.append("TraceId=").append(this.eagleEyeLogService.getTraceId()).append("\n");
        errBuilder.append("RpcId=").append(this.eagleEyeLogService.getRpcId()).append("\n");
        LOGGER.error("", errBuilder.toString(), t);
    }

    private void serverHaboLog(boolean isBizException) {
        String serviceUniqueName = this.hsfRequest.getTargetServiceUniqueName();
        String remoteHost = this.output.getConnection().getPeerIP();
        long duration = System.currentTimeMillis() - this.beginTime;
        this.monitorService.add(isBizException ? "HSF-ProviderDetail-BizException" : "HSF-ProviderDetail", serviceUniqueName, this.methodModel.getMethodLogname(), remoteHost, 1L, duration);
        int timeout = this.methodModel.getTimeout();
        if (duration > (long)(timeout - timeout >> 4)) {
            this.monitorService.add("HSF-Provider-Timeout", serviceUniqueName, this.methodModel.getMethodLogname(), 1L, duration);
            String detail = Profiler.dump();
            LOGGER.warn(MessageFormat.format("[HSF-Provider] \u6267\u884cHSF\u670d\u52a1[{0}]\u7684\u65b9\u6cd5[{1}]\u8017\u65f6[{2,number}]ms\uff0c\u63a5\u8fd1\u8d85\u65f6\u65f6\u95f4\uff0c\u53d1\u8d77\u8bf7\u6c42\u7684\u5730\u5740\u4e3a\uff1a[{3}].\n{4}\n{5}\n{6}", serviceUniqueName, this.methodModel.getMethodLogname(), duration, remoteHost, "TraceId=" + this.eagleEyeLogService.getTraceId(), "RpcId=" + this.eagleEyeLogService.getRpcId(), detail));
        }
    }
}

