/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.component;

import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.event.Event;
import com.taobao.hsf.event.EventDispatcher;
import com.taobao.hsf.event.EventListener;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookServiceAdapter;
import com.taobao.hsf.rule.RuleParseException;
import com.taobao.hsf.tps.service.TPSRule;
import com.taobao.hsf.tps.service.TPSRuleParser;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.text.MessageFormat;
import java.util.List;

public class TPSRuleProcessHookComponent
extends ProcessHookServiceAdapter
implements EventListener,
GovernanceListener {
    private static final Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private final List<TPSRuleParser> parsers = HSFServiceContainer.getInstances(TPSRuleParser.class);
    private final GovernanceService governanceService = HSFServiceContainer.getInstance(GovernanceService.class, HSFServiceContainer.getInstance(ConfigurationService.class).getGovernanceType());

    public TPSRuleProcessHookComponent() {
        EventDispatcher.addEventListener(this);
    }

    @Override
    public void afterPublish(ServiceMetadata metadata) {
        String serviceUniqueName = metadata.getUniqueName();
        String dataId = serviceUniqueName + ".TPSRULE";
        String group = metadata.getGroup();
        if (this.governanceService != null) {
            this.governanceService.getConfig(dataId, serviceUniqueName, group, this, LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0019", (String)"Biz-Problem", (String)"[TPSRule Component] Process rule failed, TPS rule [{0}], {1}"));
        }
    }

    private void registerRule(String serviceUniqueName, String rawRule) {
        if (rawRule == null || rawRule.length() == 0) {
            LOGGER_CONFIG.info(MessageFormat.format("[TPSRule Component] Received empty rule for service [{0}].", serviceUniqueName));
            return;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[TPSRule Component] Received rule for service [{0}]: {1}.", serviceUniqueName, rawRule));
        if ("@".equals(rawRule.trim())) {
            LOGGER_CONFIG.info(MessageFormat.format("[TPSRule Component] Received CLEAR command for service [{0}].", serviceUniqueName));
            ApplicationModel.instance().setTpsRule(null);
            return;
        }
        TPSRule rule = null;
        for (TPSRuleParser parser : this.parsers) {
            if (!parser.accept(rawRule)) continue;
            try {
                rule = (TPSRule)parser.parse(rawRule);
            }
            catch (RuleParseException e) {
                LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0019", (String)"Biz-Problem", (String)MessageFormat.format("[TPSRule Component] Parsed failed, raw rule: {0}, parser: {1}, exception: {2}.", rawRule, parser, e)));
            }
            if (rule == null) {
                LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0019", (String)"Biz-Problem", (String)MessageFormat.format("[TPSRule Component] Parsed failed, raw rule: {0}, parser: {1}.", rawRule, parser)));
            } else if (!rule.validate()) {
                LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0019", (String)"Biz-Problem", (String)("[TPSRule Component] Invalid rule: " + rawRule)));
            } else {
                ApplicationModel.instance().setTpsRule(rule);
                LOGGER_CONFIG.info("[TPSRule Component] Parsed OK: " + rule);
            }
            return;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[TPSRule Component] Parsed failed: no appropriate parser. Registered parsers: {0}, raw rule: {1}.", this.parsers, rawRule));
    }

    @Override
    public void onEvent(Event event) {
        switch (event.getEventType()) {
            case MetaDataChanged: {
                ServiceMetadata metadata = (ServiceMetadata)event.getSource();
                if (!metadata.isProvider()) break;
                this.afterPublish(metadata);
                break;
            }
            case MetaDataBeforeChanged: {
                ServiceMetadata metadata = (ServiceMetadata)event.getSource();
                if (!metadata.isProvider() || this.governanceService == null) break;
                this.governanceService.unRegister(metadata, ".TPSRULE");
                break;
            }
        }
    }

    @Override
    public void process(String uniqueName, String configInfo) {
        this.registerRule(uniqueName, configInfo);
    }
}

