/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.tps.model.StatList;
import com.taobao.hsf.tps.model.StatNode;
import com.taobao.middleware.logger.Logger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InvocationCollector {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final long DEFAULT_TIMEWINDOW = 600000L;
    private long timeWindow = 600000L;
    private volatile long lastRefreshTime;
    private ConcurrentMap<String, StatList> collector = new ConcurrentHashMap<String, StatList>();

    public InvocationCollector() {
        this.lastRefreshTime = System.currentTimeMillis();
    }

    public void accumulate(HSFRequest request) {
        StatList list;
        long now = System.currentTimeMillis();
        if (now > this.lastRefreshTime + this.timeWindow) {
            this.lastRefreshTime = now;
            this.doLog();
            this.collector.clear();
        }
        String appName = "UNKNOWN";
        if (request.getRequestProp("Consumer-AppName") != null) {
            appName = (String)request.getRequestProp("Consumer-AppName");
        }
        if ((list = (StatList)this.collector.get(appName)) == null) {
            list = new StatList();
            this.collector.put(appName, list);
        }
        list.append(request);
    }

    public long getConsumerAmount(String appName) {
        StatList list = (StatList)this.collector.get(appName);
        long amount = 0L;
        if (list != null && !list.isEmpty()) {
            for (StatNode node : list) {
                amount += node.getAmount();
            }
        }
        return amount;
    }

    public long getMethodAmount(HSFRequest request) {
        long amount = 0L;
        for (StatList list : this.collector.values()) {
            for (StatNode node : list) {
                if (!node.matches(request)) continue;
                amount += node.getAmount();
            }
        }
        return amount;
    }

    public long getServiceAmount(HSFRequest request) {
        long amount = 0L;
        for (StatList list : this.collector.values()) {
            for (StatNode node : list) {
                if (!node.belongsTo(request.getTargetServiceUniqueName())) continue;
                amount += node.getAmount();
            }
        }
        return amount;
    }

    public void setTimeWindow(long timeWindow) {
        this.timeWindow = timeWindow;
    }

    public String toString() {
        return "InvocationCollector [collector=" + this.collector + "]";
    }

    private void doLog() {
        StringBuffer sb = new StringBuffer();
        sb.append("HSF\u670d\u52a1\u8c03\u7528\u91cf\u7edf\u8ba1\u5668\u7edf\u8ba1\u6570\u636e\n");
        for (String appName : this.collector.keySet()) {
            sb.append("|--\u8c03\u7528\u5e94\u7528[").append(appName).append("]\n");
            for (StatNode node : (StatList)this.collector.get(appName)) {
                sb.append("  |--").append(node.getKey()).append("   ").append(node.getAmount()).append("\n");
            }
        }
        LOGGER.info(sb.toString());
    }
}

