/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.tps.service.Limiter;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenBucketLimiter
implements Limiter {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final int DEFAULT_RATE = 50;
    private static final int DEFAULT_PEAK = 100;
    private static final int DEFAULT_TIMEWINDOW = 1000;
    private int rate;
    private int peak;
    private int timeWindow;
    private AtomicInteger tokens;
    private volatile long lastRefreshTime;
    private volatile double leftDouble;

    public TokenBucketLimiter() {
        this(50, 100, 1000);
    }

    public TokenBucketLimiter(int rate, int peak, int timeWindow) {
        this.rate = rate;
        this.peak = peak;
        this.timeWindow = timeWindow;
        double initialToken = (double)(rate * timeWindow) / 1000.0;
        this.tokens = initialToken >= 1.0 ? new AtomicInteger((int)initialToken) : new AtomicInteger(1);
        this.leftDouble = initialToken - Math.floor(initialToken);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    @Override
    public boolean check() {
        long now = System.currentTimeMillis();
        if (now > this.lastRefreshTime + (long)this.timeWindow) {
            int currentValue = this.tokens.get();
            double interval = (double)(now - this.lastRefreshTime) / 1000.0;
            double addedDouble = interval * (double)this.rate;
            int added = (int)addedDouble;
            if (added > 0) {
                double addedPlusDouble;
                int addPlus;
                int newValue;
                int n = newValue = (newValue = currentValue + (added += (addPlus = (int)(addedPlusDouble = this.leftDouble + (addedDouble - (double)added))))) > currentValue && newValue < this.peak ? newValue : this.peak;
                if (this.tokens.compareAndSet(currentValue, newValue)) {
                    this.lastRefreshTime = now;
                    this.leftDouble = addedPlusDouble - (double)addPlus;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(MessageFormat.format("[TokenBucketLimiter] Updated done: [{0}] -> [{1}], refresh time: {2}.", currentValue, newValue, now));
                    }
                }
            }
        }
        int value = this.tokens.get();
        boolean flag = false;
        while (value > 0 && !flag) {
            flag = this.tokens.compareAndSet(value, value - 1);
            value = this.tokens.get();
        }
        if (LOGGER.isDebugEnabled() && !flag) {
            LOGGER.debug("TokenBucketLimiter: get token failed, tokens[" + this.tokens.get() + "]");
        }
        return flag;
    }

    public String toString() {
        return "TokenBucketLimiter [tokens=" + this.tokens + ", rate=" + this.rate + ", peak=" + this.peak + ", timeWindow=" + this.timeWindow + "]";
    }

    @Override
    public boolean validate() {
        if (this.rate <= 0 || this.peak <= 0 || this.timeWindow < 1) {
            return false;
        }
        return !((float)this.peak < (float)(this.rate * this.timeWindow) / 1000.0f);
    }
}

