/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model.whitelist;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.tps.component.encode.KeyEncoder;
import com.taobao.hsf.tps.component.encode.KeyEncoderFactory;
import com.taobao.hsf.tps.model.whitelist.BaseLevel;
import com.taobao.hsf.tps.model.whitelist.MethodLevel;
import java.util.HashMap;
import java.util.Map;

public class ServiceLevel
extends BaseLevel {
    private boolean methodNameWithArgSigs = false;
    private Map<String, MethodLevel> methods;
    private Map<String, String> keys;
    private Map<String, String> encoders;

    public ServiceLevel(String name) {
        super(name);
    }

    public void addMethodLevel(MethodLevel ml) {
        this.getMethods().put(ml.getName(), ml);
    }

    public Map<String, MethodLevel> getMethods() {
        if (this.methods == null) {
            this.methods = new HashMap<String, MethodLevel>();
        }
        return this.methods;
    }

    public Map<String, String> getKeys() {
        if (this.keys == null) {
            this.keys = new HashMap<String, String>();
        }
        return this.keys;
    }

    public void addKey(String appName, String key) {
        this.getKeys().put(appName, key);
    }

    public Map<String, String> getEncoders() {
        if (this.encoders == null) {
            this.encoders = new HashMap<String, String>();
        }
        return this.encoders;
    }

    public void addEncoder(String appName, String encoder) {
        this.getEncoders().put(appName, encoder);
    }

    public boolean isMethodNameWithArgSigs() {
        return this.methodNameWithArgSigs;
    }

    public boolean matches(String consumerAppName, HSFRequest request) {
        String[] argSigs;
        StringBuilder sb = new StringBuilder();
        sb.append(request.getMethodName());
        if (this.isMethodNameWithArgSigs() && (argSigs = request.getMethodArgSigs()) != null) {
            for (String argSig : argSigs) {
                if (argSig == null || argSig.isEmpty()) continue;
                sb.append("_").append(argSig);
            }
        }
        String methodKey = sb.toString();
        if (this.getMethods().containsKey(methodKey)) {
            MethodLevel ml = this.getMethods().get(methodKey);
            if (ml != null) {
                return ml.matches(consumerAppName, request);
            }
        } else if (this.getAppNameList().contains(consumerAppName)) {
            if (this.getKeys().containsKey(consumerAppName)) {
                String consumerKey = null;
                if (request.getRequestProp("Secure-Key") != null) {
                    consumerKey = (String)request.getRequestProp("Secure-Key");
                }
                if (consumerKey == null || consumerKey.length() == 0) {
                    return false;
                }
                String providerKey = this.getKeys().get(consumerAppName);
                KeyEncoder encoder = KeyEncoderFactory.getEncoder(this.getEncoders().get(consumerAppName));
                if (encoder == null) {
                    return false;
                }
                if (!providerKey.equals(encoder.encode(consumerKey))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void setMethodNameWithArgSigs(boolean methodNameWithArgSigs) {
        this.methodNameWithArgSigs = methodNameWithArgSigs;
    }

    public String toString() {
        return "ServiceLevel [name=" + this.getName() + ", appNameList=" + this.getAppNameList() + ", methods=" + this.methods + ", methodNameWithArgSigs=" + this.methodNameWithArgSigs + "]";
    }
}

