/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model.whitelist;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.tps.model.whitelist.ServiceLevel;
import com.taobao.hsf.tps.service.TPSRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class WhiteList
extends TPSRule {
    private Collection<String> appNameList;
    private Map<String, ServiceLevel> services;

    public void addConsumer(String appName) {
        if (!this.getAppNameList().contains(appName)) {
            this.getAppNameList().add(appName);
        }
    }

    public void addServiceLevel(ServiceLevel sl) {
        this.getServices().put(sl.getName(), sl);
    }

    public Collection<String> getAppNameList() {
        if (this.appNameList == null) {
            this.appNameList = new HashSet<String>();
        }
        return this.appNameList;
    }

    @Override
    public String getName() {
        return "WhiteList";
    }

    public Map<String, ServiceLevel> getServices() {
        if (this.services == null) {
            this.services = new HashMap<String, ServiceLevel>();
        }
        return this.services;
    }

    @Override
    public boolean matches(Object data, HSFRequest request) {
        String consumerAppName = null;
        if (request.getRequestProp("Consumer-AppName") != null) {
            consumerAppName = (String)request.getRequestProp("Consumer-AppName");
        }
        if (consumerAppName == null) {
            return true;
        }
        String serviceName = request.getTargetServiceUniqueName();
        if (this.getServices().containsKey(serviceName)) {
            ServiceLevel sl = this.getServices().get(serviceName);
            if (sl != null) {
                return sl.matches(consumerAppName, request);
            }
        } else if (this.getAppNameList().contains(consumerAppName)) {
            return true;
        }
        return false;
    }

    public String toString() {
        return "WhiteList [appNameList=" + this.appNameList + ", services=" + this.services + "]";
    }

    @Override
    public boolean validate() {
        if (this.getAppNameList().isEmpty() && this.getServices().isEmpty()) {
            return false;
        }
        for (String appName : this.getAppNameList()) {
            if (!"".equals(appName)) continue;
            return false;
        }
        for (ServiceLevel sl : this.getServices().values()) {
            if (sl == null || sl.getAppNameList().isEmpty()) {
                return false;
            }
            for (String appName : sl.getAppNameList()) {
                if (!"".equals(appName)) continue;
                return false;
            }
        }
        return true;
    }
}

