/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;

public class AppInfoUtils {
    public static final String PARAM_MARKING_PROJECT = "project.name";
    private static final String PARAM_MARKING_JBOSS = "jboss.server.home.dir";
    private static final String PARAM_MARKING_JETTY = "jetty.home";
    private static final String PARAM_MARKING_TOMCAT = "catalina.base";
    private static final String LINUX_ADMIN_HOME = "/home/admin/";
    private static final String SERVER_JBOSS = "jboss";
    private static final String SERVER_JETTY = "jetty";
    private static final String SERVER_TOMCAT = "tomcat";
    private static final String SERVER_UNKNOWN = "unknown server";
    private static final String appName = AppInfoUtils.initAppName();
    private static String serverType = null;
    public static final AtomicBoolean appInited = new AtomicBoolean(false);
    public static int hsfSpringBeanCountDown = 0;

    public static String getAppName() {
        return appName;
    }

    private static String initAppName() {
        String appName = System.getProperty(PARAM_MARKING_PROJECT);
        if (appName != null) {
            return appName;
        }
        String serverHome = null;
        if (SERVER_JBOSS.equals(AppInfoUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_JBOSS);
        } else if (SERVER_JETTY.equals(AppInfoUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_JETTY);
        } else if (SERVER_TOMCAT.equals(AppInfoUtils.getServerType())) {
            serverHome = System.getProperty(PARAM_MARKING_TOMCAT);
        }
        if (serverHome != null && serverHome.startsWith(LINUX_ADMIN_HOME)) {
            appName = StringUtils.substringBetween((String)serverHome, (String)LINUX_ADMIN_HOME, (String)File.separator);
        }
        String root = AppInfoUtils.class.getResource("/").getPath();
        appName = root.substring(0, root.length() - 1);
        if ((appName = root.substring(appName.lastIndexOf(47) + 1, appName.length())) != null && !appName.equals("ROOT")) {
            return appName;
        }
        return "unknown";
    }

    public static String getServerType() {
        if (serverType != null) {
            return serverType;
        }
        serverType = System.getProperty(PARAM_MARKING_JBOSS) != null ? SERVER_JBOSS : (System.getProperty(PARAM_MARKING_JETTY) != null ? SERVER_JETTY : (System.getProperty(PARAM_MARKING_TOMCAT) != null ? SERVER_TOMCAT : SERVER_UNKNOWN));
        return serverType;
    }
}

