/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.taobao.hsf.HSFPluggable;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class HSFServiceContainer {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String PREFIX = "META-INF/services/";
    private static final ConcurrentHashMap<Class<?>, Object> INSTANCE_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Map<String, Class<?>>> MAP_CLASSES_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> MAP_INSTANCEES_CACHE = new ConcurrentHashMap();

    public static <T> T getInstance(Class<T> classType) {
        Object instance = INSTANCE_CACHE.get(classType);
        if (instance == null) {
            try {
                instance = ServiceLoader.load(classType, HSFServiceContainer.class.getClassLoader()).iterator().next();
                INSTANCE_CACHE.putIfAbsent(classType, instance);
                return (T)INSTANCE_CACHE.get(classType);
            }
            catch (Throwable e) {
                if (HSFPluggable.class.isAssignableFrom(classType)) {
                    LOGGER.warn("plugin: " + classType.getName() + " is not activated.");
                    return null;
                }
                throw new RuntimeException("Cannot Load " + classType, e);
            }
        }
        if (classType.isAssignableFrom(instance.getClass())) {
            return (T)instance;
        }
        throw new RuntimeException("[Init HSFService Container Error]" + classType);
    }

    public static <T> List<T> getInstances(Class<T> classType) {
        ArrayList<T> list = (ArrayList<T>)INSTANCE_CACHE.get(classType);
        if (list == null) {
            try {
                list = new ArrayList<T>();
                for (T instance : ServiceLoader.load(classType, HSFServiceContainer.class.getClassLoader())) {
                    list.add(instance);
                }
                INSTANCE_CACHE.putIfAbsent(classType, list);
                return (List)INSTANCE_CACHE.get(classType);
            }
            catch (RuntimeException e) {
                if (HSFPluggable.class.isAssignableFrom(classType)) {
                    LOGGER.warn("plugin: " + classType.getName() + " is not activated.");
                    return null;
                }
                throw e;
            }
        }
        if (List.class.isAssignableFrom(list.getClass())) {
            return list;
        }
        throw new RuntimeException("[Init HSFService Container Error(List)]" + classType);
    }

    public static <T> T getInstance(Class<T> classType, String key) {
        Object obj;
        ConcurrentHashMap<String, Object> objMap = MAP_INSTANCEES_CACHE.get(classType);
        if (objMap == null) {
            objMap = new ConcurrentHashMap();
            MAP_INSTANCEES_CACHE.putIfAbsent(classType, objMap);
        }
        if ((obj = (objMap = MAP_INSTANCEES_CACHE.get(classType)).get(key)) != null) {
            return (T)obj;
        }
        Map<String, Class<?>> classMap = MAP_CLASSES_CACHE.get(classType);
        if (classMap == null) {
            HSFServiceContainer.loadFile(classType);
        }
        if ((classMap = MAP_CLASSES_CACHE.get(classType)) == null) {
            throw new IllegalStateException("Failed to load extension class(interface: " + classType + ", key: " + key + ")");
        }
        Class<?> clazz = classMap.get(key);
        if (clazz != null) {
            try {
                Object newObj = clazz.newInstance();
                Object provious = objMap.putIfAbsent(key, newObj);
                return (T)(null == provious ? newObj : provious);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load extension class(interface: " + classType + ", key: " + key + ")", e);
            }
        }
        throw new IllegalStateException("Failed to load extension class(interface: " + classType + ", key: " + key + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFile(Class<?> type) {
        String fileName = PREFIX + type.getName();
        HashMap map = new HashMap();
        try {
            ClassLoader classLoader = HSFServiceContainer.class.getClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                        try {
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                int ci = line.indexOf(35);
                                if (ci >= 0) {
                                    line = line.substring(0, ci);
                                }
                                if ((line = line.trim()).length() <= 0) continue;
                                try {
                                    String name = null;
                                    int i = line.indexOf(61);
                                    if (i > 0) {
                                        name = line.substring(0, i).trim();
                                        line = line.substring(i + 1).trim();
                                    }
                                    if (line.length() <= 0) continue;
                                    Class<?> clazz = Class.forName(line, false, classLoader);
                                    if (!type.isAssignableFrom(clazz)) {
                                        throw new IllegalStateException("Error when load extension class(interface: " + type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + "is not subtype of interface.");
                                    }
                                    map.put(name, clazz);
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("", "Exception when load extension class(interface: " + type + ", class file: " + url + ") in " + url, t);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("", "Exception when load extension class(interface: " + type + ", description file: " + fileName + ").", t);
        }
        MAP_CLASSES_CACHE.put(type, map);
    }
}

