/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.util.Map;
import java.util.Properties;

public class HSFServiceTargetUtil {
    private static final char AND = '&';
    private static final char COLON = ':';
    private static final char QUEST = '?';
    private static final char EQUAL = '=';
    public static final byte HESSIAN_SERIALIZE = 1;
    public static final byte JAVA_SERIALIZE = 2;
    public static final byte TOP_SERIALIZE = 3;
    public static final byte HESSIAN2_SERIALIZE = 4;
    public static final byte KRYO_SERIALIZE = 5;
    public static final byte JSON_SERIALIZE = 6;
    public static final byte CUSTOM_SERIALIZE = 7;

    public static String formatTargetURL(String targetURL) {
        targetURL = targetURL.replace("hessian2", "4");
        targetURL = targetURL.replace("hessian", "1");
        targetURL = targetURL.replace("java", "2");
        targetURL = targetURL.replace("kryo", "5");
        targetURL = targetURL.replace("json", "6");
        targetURL = targetURL.replace("custom", "7");
        return targetURL;
    }

    public static int convertSerializeType(String type) {
        if ("java".endsWith(type)) {
            return 2;
        }
        if ("hessian2".endsWith(type)) {
            return 4;
        }
        if ("hessian".endsWith(type)) {
            return 1;
        }
        if ("kryo".endsWith(type)) {
            return 5;
        }
        if ("json".endsWith(type)) {
            return 6;
        }
        if ("custom".endsWith(type)) {
            return 7;
        }
        throw new IllegalArgumentException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0007", (String)"Biz-Problem", (String)"unsurpport serialize type."));
    }

    public static String getTarget(int port, ServiceMetadata serviceMetadata) {
        StringBuilder sb = new StringBuilder("hsf://");
        sb.append(InetAddressUtil.getIP());
        sb.append(':');
        sb.append(port);
        Map<String, String> props = serviceMetadata.getServiceProperties();
        sb.append('?');
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String k = entry.getKey().toString();
            if (k.equals("sync")) continue;
            String v = entry.getValue().toString();
            sb.append(k).append('=');
            sb.append(v).append('&');
        }
        for (MethodSpecial special : serviceMetadata.getMethodSpecials()) {
            sb.append(special.toString()).append('&');
        }
        if (props.containsKey("sync")) {
            String v = props.get("sync");
            sb.append("sync").append('=');
            sb.append(v).append('&');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getTargetIP(String serviceTarget) {
        if (serviceTarget == null || "".equals(serviceTarget.trim()) || serviceTarget.indexOf(58) == -1) {
            return null;
        }
        return serviceTarget.substring(0, serviceTarget.indexOf(58));
    }

    public static String getTargetPort(String serviceTarget) {
        if (serviceTarget == null || "".equals(serviceTarget.trim()) || serviceTarget.indexOf(58) == -1) {
            return null;
        }
        int index = serviceTarget.indexOf(63);
        int sepIndex = serviceTarget.indexOf(58);
        if (index != -1) {
            return serviceTarget.substring(sepIndex + 1, index);
        }
        return serviceTarget.substring(sepIndex + 1);
    }

    public static Properties getTargetProperties(String serviceTarget) {
        Properties props = new Properties();
        if (serviceTarget == null || "".equals(serviceTarget.trim()) || serviceTarget.indexOf(63) == -1) {
            return props;
        }
        String propsString = serviceTarget.substring(serviceTarget.indexOf(63) + 1);
        String[] propPairs = propsString.split("&");
        for (int i = 0; i < propPairs.length; ++i) {
            String propPair = propPairs[i];
            int index = propPair.indexOf(61);
            props.put(propPair.substring(0, index), propPair.substring(index + 1));
        }
        return props;
    }

    public static boolean isGeneric(String generic) {
        return generic != null && !"".equals(generic) && ("true".equalsIgnoreCase(generic) || "nativejava".equalsIgnoreCase(generic));
    }
}

