/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

public final class StringSplitter {
    private String rawRule = null;
    private String[] headers = null;

    public StringSplitter(String rawRule) {
        this(rawRule, new String[0]);
    }

    public StringSplitter(String rawRule, String ... headers) {
        this.rawRule = rawRule;
        this.headers = headers;
    }

    public String get(String header) {
        if (this.rawRule == null || this.rawRule.length() == 0 || header == null || header.length() == 0) {
            return null;
        }
        int beginIndex = this.rawRule.indexOf(header);
        if (beginIndex < 0) {
            return null;
        }
        if (this.headers == null || this.headers.length == 0) {
            return this.rawRule.substring(beginIndex);
        }
        int endIndex = this.rawRule.length();
        int indexOfRuleBody = beginIndex + header.length();
        for (String h : this.headers) {
            int position = this.rawRule.indexOf(h);
            if (position < indexOfRuleBody || position >= endIndex) continue;
            endIndex = position;
        }
        return this.rawRule.substring(beginIndex, endIndex);
    }

    public boolean has(String header) {
        if (this.rawRule == null || this.rawRule.length() == 0 || header == null || header.length() == 0) {
            return false;
        }
        return this.rawRule.contains(header);
    }
}

