/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common;

import com.alibaba.dubbo.common.utils.ClassHelper;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;

public final class Version {
    static final Logger logger = LoggerInit.LOGGER;
    private static final String VERSION = Version.getVersion(Version.class, "2.0.0");
    private static final boolean INTERNAL = Version.hasResource("com/alibaba/dubbo/registry/internal/RemoteRegistry.class");
    private static final boolean COMPATIBLE = Version.hasResource("com/taobao/remoting/impl/ConnectionRequest.class");

    private Version() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isInternalVersion() {
        return INTERNAL;
    }

    public static boolean isCompatibleVersion() {
        return COMPATIBLE;
    }

    private static boolean hasResource(String path) {
        try {
            return Version.class.getClassLoader().getResource(path) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        return "2.6.1";
    }

    public static void checkDuplicate(Class<?> cls, boolean failOnError) {
        Version.checkDuplicate(cls.getName().replace('.', '/') + ".class", failOnError);
    }

    public static void checkDuplicate(Class<?> cls) {
        Version.checkDuplicate(cls, false);
    }

    public static void checkDuplicate(String path, boolean failOnError) {
        try {
            Enumeration<URL> urls = ClassHelper.getCallerClassLoader(Version.class).getResources(path);
            HashSet<String> files = new HashSet<String>();
            while (urls.hasMoreElements()) {
                String file;
                URL url = urls.nextElement();
                if (url == null || (file = url.getFile()) == null || file.length() <= 0) continue;
                files.add(file);
            }
            if (files.size() > 1) {
                String error = "Duplicate class " + path + " in " + files.size() + " jar " + files;
                if (failOnError) {
                    throw new IllegalStateException(error);
                }
                logger.error("", error);
            }
        }
        catch (Throwable e) {
            logger.error("", e.getMessage(), e);
        }
    }

    static {
        Version.checkDuplicate(Version.class);
    }
}

