/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http;

import com.alibaba.dubbo.rpc.http.HttpProcessor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServiceDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 5766349180380479888L;
    private static final Map<String, HttpProcessor> processors = new ConcurrentHashMap<String, HttpProcessor>();

    public static void addProcessor(int port, String uri, HttpProcessor processor) {
        processors.put(ServiceDispatcherServlet.key(port, uri), processor);
    }

    public static void removeProcessor(int port, String uri) {
        processors.remove(ServiceDispatcherServlet.key(port, uri));
    }

    private static String key(int port, String uri) {
        return port + ":" + (uri.startsWith("/") ? uri : "/" + uri);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpProcessor processor;
        int i;
        String uri = request.getRequestURI();
        String contentType = request.getContentType();
        if ((contentType == null || "application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) && (i = uri.lastIndexOf(47)) >= 0) {
            uri = uri.substring(0, i);
        }
        if ((processor = processors.get(ServiceDispatcherServlet.key(request.getLocalPort(), uri))) == null) {
            response.sendError(404, "Service not found.");
        } else {
            processor.invoke(request, response);
        }
    }
}

