/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.codec.support;

import com.alibaba.dubbo.common.serialize.support.dubbo.GenericObjectInput;
import com.alibaba.dubbo.common.serialize.support.dubbo.GenericObjectOutput;
import com.alibaba.dubbo.rpc.http.codec.StreamCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DubboCodec
extends StreamCodec {
    @Override
    public String getName() {
        return "dubbo";
    }

    @Override
    public void encode(OutputStream output, Object value) throws IOException {
        GenericObjectOutput o = new GenericObjectOutput(output);
        o.writeObject(value);
        o.flushBuffer();
    }

    @Override
    public Object decode(InputStream input, Class<?> type) throws IOException {
        try {
            GenericObjectInput oi = new GenericObjectInput(input);
            return oi.readObject(type);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void encode(OutputStream output, Object[] value) throws IOException {
        GenericObjectOutput o = new GenericObjectOutput(output);
        for (Object obj : value) {
            o.writeObject(obj);
        }
        o.flushBuffer();
    }

    @Override
    public Object[] decode(InputStream input, Class<?>[] types) throws IOException {
        GenericObjectInput oi = new GenericObjectInput(input);
        Object[] ret = new Object[types.length];
        try {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = oi.readObject(types[i]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        return ret;
    }
}

