/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.codec.support;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.http.codec.TextCodec;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Map;

public class FastJsonCodec
extends TextCodec {
    @Override
    public String getName() {
        return "fastjson";
    }

    @Override
    public void encode(Writer output, Object value) throws IOException {
        try {
            SerializeWriter out = new SerializeWriter();
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.config(SerializerFeature.WriteClassName, true);
            serializer.write(value);
            out.writeTo(output);
        }
        catch (Exception e) {
            throw new IOException(StringUtils.toString(e));
        }
        finally {
            output.flush();
        }
    }

    @Override
    public Object decode(Reader input, Class<?> type) throws IOException {
        if (null == type) {
            type = Map.class;
        }
        String jsonString = FastJsonCodec.readToString(input);
        return JSON.parseObject((String)jsonString, type);
    }

    @Override
    public void encode(Writer output, Object[] value) throws IOException {
        try {
            SerializeWriter out = new SerializeWriter();
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.config(SerializerFeature.WriteClassName, true);
            serializer.write((Object)value);
            out.writeTo(output);
        }
        catch (Exception e) {
            throw new IOException(StringUtils.toString(e));
        }
        finally {
            output.flush();
        }
    }

    @Override
    public Object[] decode(Reader input, Class<?>[] types) throws IOException {
        String jsonString = FastJsonCodec.readToString(input);
        DefaultJSONParser parser = new DefaultJSONParser(jsonString, ParserConfig.getGlobalInstance());
        return parser.parseArray((Type[])types);
    }

    private static String readToString(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[8192];
        int len = 0;
        while ((len = reader.read(buf)) != -1) {
            buffer.append(buf, 0, len);
        }
        return buffer.toString();
    }
}

