/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.codec.support;

import com.alibaba.dubbo.common.json.JSON;
import com.alibaba.dubbo.common.json.ParseException;
import com.alibaba.dubbo.rpc.http.codec.TextCodec;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class JsonCodec
extends TextCodec {
    @Override
    public String getName() {
        return "json";
    }

    @Override
    public void encode(Writer output, Object value) throws IOException {
        JSON.json(value, output);
        output.flush();
    }

    @Override
    public Object decode(Reader input, Class<?> type) throws IOException {
        if (null == type) {
            type = Map.class;
        }
        try {
            return JSON.parse(input, type);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void encode(Writer output, Object[] value) throws IOException {
        JSON.json((Object)value, output);
        output.flush();
    }

    @Override
    public Object[] decode(Reader input, Class<?>[] type) throws IOException {
        try {
            return JSON.parse(input, type);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }
}

