/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.Dubbo2Response;
import com.taobao.hsf.remoting.ProtocolFactory;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.hsf.remoting.util.BytesUtil;
import java.io.OutputStream;

public class Dubbo2Request
extends BaseRequest {
    private static final ServerHandler<? extends BaseRequest> serverHandler = ProtocolFactory.instance.getServerHandler(RemotingConstants.PROCOCOL_VERSION_DUBBO_REMOTING);
    public static final String HEARTBEAT_EVENT = null;
    public static final String READONLY_EVENT = "R";
    private final String mVersion;
    private byte[] mData;
    private final byte codecType;
    private boolean mTwoWay = true;
    private boolean mEvent = false;
    private boolean mBroken = false;

    public Dubbo2Request(long id, String mVersion, byte[] mData, byte codecType, int timeout) {
        super(RemotingConstants.PROCOCOL_VERSION_DUBBO_REMOTING, id, timeout);
        this.mData = mData;
        this.mVersion = mVersion;
        this.codecType = codecType;
    }

    public Dubbo2Request(long id, String mVersion, byte[] mData, byte codecType) {
        this(id, mVersion, mData, codecType, 3000);
    }

    public Dubbo2Request(long id, String mVersion, byte codecType) {
        this(id, mVersion, new byte[]{78}, codecType, 3000);
    }

    public boolean isTwoway() {
        return this.mTwoWay;
    }

    public void setTwoway(boolean mTwoWay) {
        this.mTwoWay = mTwoWay;
    }

    public boolean isEvent() {
        return this.mEvent;
    }

    public void setEvent(boolean mEvent) {
        this.mEvent = mEvent;
    }

    public void setEvent(String event) {
        this.mEvent = true;
        if (event != null) {
            this.mData = event.getBytes(RemotingConstants.DEFAULT_CHARSET);
        }
    }

    public boolean ismBroken() {
        return this.mBroken;
    }

    public boolean isHeartbeat() {
        return this.mEvent && null == this.mData;
    }

    public void setmBroken(boolean mBroken) {
        this.mBroken = mBroken;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public byte[] getData() {
        return this.mData;
    }

    public byte getCodecType() {
        return this.codecType;
    }

    @Override
    public BaseResponse createErrorResponse(String responseInfo) {
        Exception exception = new Exception(responseInfo);
        exception.fillInStackTrace();
        byte[] responseBytes = null;
        try {
            UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
            ObjectOutput objectOutput = CodecSupport.getSerializationById((Byte)this.getCodecType()).serialize(null, (OutputStream)os);
            objectOutput.writeByte((byte)0);
            objectOutput.writeObject((Object)new Exception(responseInfo));
            responseBytes = os.toByteArray();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new Dubbo2Response(this.getRequestID(), this.mVersion, responseBytes, this.codecType);
    }

    @Override
    public ServerHandler<? extends BaseRequest> getServerHandler() {
        return serverHandler;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        byte[] header = new byte[16];
        BytesUtil.short2bytes((short)-9541, header);
        header[2] = (byte)(0xFFFFFF80 | this.getCodecType());
        if (this.isTwoway()) {
            header[2] = (byte)(header[2] | 0x40);
        }
        if (this.isEvent()) {
            header[2] = (byte)(header[2] | 0x20);
        }
        BytesUtil.long2bytes(this.getRequestID(), header, 4);
        BytesUtil.int2bytes(this.getData().length, header, 12);
        bytebufferWrapper.ensureCapacity(16 + this.getData().length);
        bytebufferWrapper.writeBytes(header);
        bytebufferWrapper.writeBytes(this.getData());
    }

    @Override
    public int size() {
        return this.mData == null ? 0 : this.mData.length;
    }
}

