/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.adaptor.dubbo.DecodeableRpcResult;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.util.BytesUtil;
import java.io.ByteArrayInputStream;

public class Dubbo2Response
extends BaseResponse {
    public static final String HEARTBEAT_EVENT = null;
    public static final String READONLY_EVENT = "R";
    private String mVersion;
    private boolean mEvent = false;
    private byte[] mResult;
    private byte codecType;

    public Dubbo2Response(long id, String mVersion, byte[] mResult, byte codecType) {
        super(RemotingConstants.PROCOCOL_VERSION_DUBBO_REMOTING, id);
        this.mResult = mResult;
        this.mVersion = mVersion;
        this.codecType = codecType;
    }

    public String getmVersion() {
        return this.mVersion;
    }

    public void setmVersion(String mVersion) {
        this.mVersion = mVersion;
    }

    public boolean ismEvent() {
        return this.mEvent;
    }

    public void setmEvent(boolean mEvent) {
        this.mEvent = mEvent;
    }

    public byte[] getmResult() {
        return this.mResult;
    }

    public void setmResult(byte[] mResult) {
        this.mResult = mResult;
    }

    public byte getCodecType() {
        return this.codecType;
    }

    public boolean isHeartbeat() {
        return this.mEvent;
    }

    public void setCodecType(byte codecType) {
        this.codecType = codecType;
    }

    public void setEvent(String event) {
        this.mEvent = true;
        this.mResult = (byte[])(event != null ? event.getBytes(RemotingConstants.DEFAULT_CHARSET) : null);
    }

    public void setEvent(byte[] event) {
        this.mEvent = true;
        this.mResult = event;
    }

    @Override
    public HSFResponse getResponseObject(BaseRequest request) {
        DecodeableRpcResult result = new DecodeableRpcResult(new ByteArrayInputStream(this.getmResult()), this.getCodecType());
        HSFResponse response = new HSFResponse();
        try {
            result.decode();
            if (result.hasException()) {
                response.setAppResponse((Object)result.getException());
            } else {
                response.setAppResponse(result.getValue());
            }
        }
        catch (Throwable e) {
            response.setClientErrorMsg("[Remoting] decode error on client side");
            response.setAppResponse((Object)e);
        }
        return response;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        byte status;
        byte[] header = new byte[16];
        BytesUtil.short2bytes((short)-9541, header);
        header[2] = this.getCodecType();
        if (this.isHeartbeat()) {
            header[2] = (byte)(header[2] | 0x20);
        }
        header[3] = status = this.getStatus().getCode();
        BytesUtil.long2bytes(this.getRequestID(), header, 4);
        int dataLength = this.getmResult() == null ? 0 : this.getmResult().length;
        BytesUtil.int2bytes(dataLength, header, 12);
        bytebufferWrapper.ensureCapacity(16 + dataLength);
        bytebufferWrapper.writeBytes(header);
        bytebufferWrapper.writeBytes(this.getmResult());
    }

    @Override
    public int size() {
        return this.mResult == null ? 0 : this.mResult.length;
    }
}

