/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.Dubbo2Request;
import com.taobao.hsf.remoting.HeartBeatRequest;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.TbRemotingRequest;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.util.RemotingUtil;
import com.taobao.hsf.remoting.util.UUIDGenerator;
import com.taobao.remoting.impl.ConnectionHeartBeat;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.OutputStream;

public enum EnumRemotingType {
    HSF2{

        @Override
        public BaseRequest convertRequest(HSFRequest request, byte codecType, int timeout, Client client) throws Exception {
            return RemotingUtil.convert2RpcRequest(request, codecType, timeout);
        }

        @Override
        public BaseRequest generateHBRequest(Client client) throws Exception {
            return new HeartBeatRequest();
        }
    }
    ,
    HSF1{

        @Override
        public BaseRequest convertRequest(HSFRequest request, byte codecType, int timeout, Client client) throws Exception {
            return RemotingUtil.convert2TbRemotingRequest(request, codecType, timeout);
        }

        @Override
        public BaseRequest generateHBRequest(Client client) throws Exception {
            ConnectionRequest request = new ConnectionRequest((Object)new ConnectionHeartBeat(client.getUrl().toString()));
            request.setSerializeProtocol((byte)1);
            SliceOutputStream os2 = new SliceOutputStream();
            RemotingConstants.CONN_REQUEST_SERIALIZER.serialize(request, (byte)1, (OutputStream)os2);
            return new TbRemotingRequest(os2, request.getMessageId(), 1, 3000);
        }
    }
    ,
    DUBBO2{

        @Override
        public BaseRequest convertRequest(HSFRequest request, byte codecType, int timeout, Client client) throws Exception {
            return RemotingUtil.convert2Dubbo2Request(request, codecType, timeout, client.getUrl());
        }

        @Override
        public BaseRequest generateHBRequest(Client client) throws Exception {
            Dubbo2Request req = new Dubbo2Request(UUIDGenerator.getNextOpaque(), "2.5.4", 2);
            req.setEvent(true);
            req.setTwoway(true);
            return req;
        }
    }
    ,
    DUBBO1{

        @Override
        public BaseRequest convertRequest(HSFRequest request, byte codecType, int timeout, Client client) throws Exception {
            return RemotingUtil.convert2Dubbo1Request(request, client.getUrl(), timeout);
        }

        @Override
        public BaseRequest generateHBRequest(Client client) throws Exception {
            ConnectionRequest request = new ConnectionRequest((Object)new ConnectionHeartBeat(client.getUrl().toString()));
            request.setSerializeProtocol((byte)4);
            SliceOutputStream os = new SliceOutputStream();
            RemotingConstants.CONN_REQUEST_SERIALIZER.serialize(request, (byte)4, (OutputStream)os);
            return new TbRemotingRequest(os, request.getMessageId(), 4, 3000);
        }
    };


    public abstract BaseRequest convertRequest(HSFRequest var1, byte var2, int var3, Client var4) throws Exception;

    public abstract BaseRequest generateHBRequest(Client var1) throws Exception;
}

