/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.protocol.DubboProtocol;
import com.taobao.hsf.remoting.protocol.HeartBeatProtocol;
import com.taobao.hsf.remoting.protocol.Protocol;
import com.taobao.hsf.remoting.protocol.RPCProtocol;
import com.taobao.hsf.remoting.protocol.TbRemotingProtocol;
import com.taobao.hsf.remoting.server.DubboRemotingHandler;
import com.taobao.hsf.remoting.server.HeartBeatServerHandler;
import com.taobao.hsf.remoting.server.RPCServerHandler;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.hsf.remoting.server.TbRemotingHandler;

public final class ProtocolFactory {
    private final Protocol[] protocolHandlers = new Protocol[256];
    private final ServerHandler<?>[] serverHandlers = new ServerHandler[256];
    public static ProtocolFactory instance = new ProtocolFactory();

    private ProtocolFactory() {
        this.registerProtocol((byte)14, new RPCProtocol());
        this.registerProtocol((byte)12, new HeartBeatProtocol());
        this.registerProtocol((byte)13, new TbRemotingProtocol());
        this.registerProtocol(RemotingConstants.PROCOCOL_VERSION_DUBBO_REMOTING, new DubboProtocol());
    }

    public void initServerSide(RpcRequestProcessor rpcRequestProcessor) {
        this.registerServerHandler((byte)14, new RPCServerHandler(rpcRequestProcessor));
        this.registerServerHandler((byte)12, new HeartBeatServerHandler());
        this.registerServerHandler((byte)13, new TbRemotingHandler(rpcRequestProcessor));
        this.registerServerHandler(RemotingConstants.PROCOCOL_VERSION_DUBBO_REMOTING, new DubboRemotingHandler(rpcRequestProcessor));
    }

    private void registerProtocol(byte type, Protocol customProtocol) {
        if (this.protocolHandlers[type & 0xFF] != null) {
            throw new RuntimeException("protocol header's sign is overlapped");
        }
        this.protocolHandlers[type & 0xFF] = customProtocol;
    }

    private void registerServerHandler(byte type, ServerHandler<?> customServerHandler) {
        this.serverHandlers[type & 0xFF] = customServerHandler;
    }

    public Protocol getProtocol(byte type) {
        return this.protocolHandlers[type & 0xFF];
    }

    public ServerHandler<?> getServerHandler(byte type) {
        return this.serverHandlers[type & 0xFF];
    }
}

