/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.alibaba.dubbo.common.utils.PojoUtils;
import com.taobao.hsf.remoting.RemotingRuntimeInfoModel;
import com.taobao.hsf.remoting.util.LongAdder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RemotingRuntimeInfoHolder {
    private final LongAdder countSendRequests = new LongAdder();
    private final LongAdder countReceivedResponses = new LongAdder();
    private final LongAdder countProcessRequests = new LongAdder();
    private final LongAdder countConnectionsAsClient = new LongAdder();
    private final LongAdder countConnectionsAsServer = new LongAdder();
    private volatile boolean countService = false;
    private volatile String uniqueServiceName;
    private volatile int scount = 1;
    private volatile List<RemotingRuntimeInfoModel> slist = new ArrayList<RemotingRuntimeInfoModel>();
    private Object slock = new Object();
    private volatile boolean countConsumer = false;
    private volatile String uniqueConsumerName;
    private volatile int ccount = 1;
    private volatile List<RemotingRuntimeInfoModel> clist = new ArrayList<RemotingRuntimeInfoModel>();
    private Object clock = new Object();
    private static final RemotingRuntimeInfoHolder instance = new RemotingRuntimeInfoHolder();

    private RemotingRuntimeInfoHolder() {
    }

    public static RemotingRuntimeInfoHolder getInstance() {
        return instance;
    }

    public String getInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("countSendRequests:").append(RemotingRuntimeInfoHolder.getInstance().getcountSendRequests()).append(",\n countReceivedResponses:").append(RemotingRuntimeInfoHolder.getInstance().getcountReceivedResponses()).append(",\n countProcessRequests:").append(RemotingRuntimeInfoHolder.getInstance().getcountProcessRequests()).append(",\n countConnectionsAsClient:").append(RemotingRuntimeInfoHolder.getInstance().getCountConnectionsAsClient()).append(",\n countConnectionsAsServer:").append(RemotingRuntimeInfoHolder.getInstance().getCountConnectionsAsServer());
        return builder.toString();
    }

    public long getcountSendRequests() {
        return this.countSendRequests.longValue();
    }

    public void increasecountSendRequests() {
        this.countSendRequests.increment();
    }

    public long getcountReceivedResponses() {
        return this.countReceivedResponses.longValue();
    }

    public void increasecountReceivedResponses() {
        this.countReceivedResponses.increment();
    }

    public long getcountProcessRequests() {
        return this.countProcessRequests.longValue();
    }

    public long getCountConnectionsAsClient() {
        return this.countConnectionsAsClient.longValue();
    }

    public long getCountConnectionsAsServer() {
        return this.countConnectionsAsServer.longValue();
    }

    public void increaseCountConnectionsAsClient() {
        this.countConnectionsAsClient.increment();
    }

    public void increaseCountConnectionsAsServer() {
        this.countConnectionsAsServer.increment();
    }

    public void decreaseCountConnectionsAsClient() {
        this.countConnectionsAsClient.decrement();
    }

    public void decreaseCountConnectionsAsServer() {
        this.countConnectionsAsServer.decrement();
    }

    public void increasecountProcessRequests() {
        this.countProcessRequests.decrement();
    }

    public boolean isCountService() {
        return this.countService;
    }

    public void setCountService(boolean countService) {
        this.countService = countService;
    }

    public boolean isCountConsumer() {
        return this.countConsumer;
    }

    public void setCountConsumer(boolean countConsumer) {
        this.countConsumer = countConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(String methodName, String consumerName, Object[] methodArgs, Object result, long time) {
        if (StringUtils.equals((String)consumerName, (String)this.uniqueConsumerName)) {
            RemotingRuntimeInfoModel m = new RemotingRuntimeInfoModel();
            m.setMethodName(methodName);
            m.setInParams(PojoUtils.generalize((Object[])methodArgs));
            m.setResult(PojoUtils.generalize((Object)result));
            m.setTime(time);
            this.clist.add(m);
        }
        if (this.clist.size() >= this.ccount) {
            Object object = this.clock;
            synchronized (object) {
                this.countConsumer = false;
                this.clock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCountConsumer(String consumerName, int count) {
        try {
            Object object = this.clock;
            synchronized (object) {
                this.uniqueConsumerName = consumerName;
                this.clist.clear();
                if (count > 0) {
                    this.ccount = count;
                }
                this.countConsumer = true;
                this.clock.wait(60000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List<RemotingRuntimeInfoModel> getCountConsumer() {
        return this.clist;
    }

    public void endCountConsumer() {
        this.countConsumer = false;
        this.clist.clear();
        this.ccount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(String methodName, String serviceName, Object[] methodArgs, Object result, long time) {
        if (StringUtils.equals((String)serviceName, (String)this.uniqueServiceName)) {
            RemotingRuntimeInfoModel m = new RemotingRuntimeInfoModel();
            m.setMethodName(methodName);
            m.setInParams(PojoUtils.generalize((Object[])methodArgs));
            m.setResult(PojoUtils.generalize((Object)result));
            m.setTime(time);
            this.slist.add(m);
        }
        if (this.slist.size() >= this.scount) {
            Object object = this.slock;
            synchronized (object) {
                this.countService = false;
                this.slock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCountService(String serviceName, int count) {
        try {
            Object object = this.slock;
            synchronized (object) {
                this.uniqueServiceName = serviceName;
                this.slist.clear();
                if (count > 0) {
                    this.scount = count;
                }
                this.countService = true;
                this.slock.wait(60000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List<RemotingRuntimeInfoModel> getCountService() {
        return this.slist;
    }

    public void endCountService() {
        this.countService = false;
        this.slist.clear();
        this.scount = 1;
    }
}

