/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.CustomizedSerializerHelper;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.RpcRequest;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.serialize.Codecs;
import com.taobao.middleware.logger.support.LoggerHelper;

public class RpcResponse
extends BaseResponse {
    private static final byte[] EXTENED_BYTES = new byte[3];
    private final byte codecType;
    private final byte[] response;

    public RpcResponse(long requestId, byte codecType, ResponseStatus status, byte[] response) {
        super(14, requestId);
        this.codecType = codecType;
        this.response = response;
        this.setStatus(status);
    }

    public RpcResponse(long requestId, byte codecType, byte status, byte[] response) {
        super(14, requestId);
        this.codecType = codecType;
        this.response = response;
        this.setStatus(status);
    }

    public RpcResponse(long requestId, byte codecType, byte[] response) {
        super(14, requestId);
        this.codecType = codecType;
        this.response = response;
    }

    public byte getCodecType() {
        return this.codecType;
    }

    public byte[] getResponse() {
        return this.response;
    }

    @Override
    public HSFResponse getResponseObject(BaseRequest request) {
        HSFResponse response = new HSFResponse();
        switch (this.getStatus()) {
            case OK: {
                try {
                    byte codecType = this.getCodecType();
                    Object responseObject = null;
                    responseObject = codecType != 7 ? Codecs.getDecoder(codecType).decode(this.getResponse()) : CustomizedSerializerHelper.getTransformer((String)((RpcRequest)request).getMethodKey()).decodeResult(this.getResponse());
                    response.setAppResponse(responseObject);
                }
                catch (Throwable e) {
                    LoggerInit.LOGGER.error("", "Deserialize error on client side", (Throwable)new RuntimeException(LoggerHelper.getErrorCodeStr((String)"HSF", (String)"HSF-0037", (String)"\u6d93\u6c2c\u59df\u95c2\ue1c0\ue57d", (String)"Deserialize error on client side")));
                    response.setClientErrorMsg("[Remoting] Decode error on client side:" + e.getMessage());
                    response.setAppResponse((Object)e);
                }
                break;
            }
            default: {
                response.setClientErrorMsg(new String(this.getResponse(), RemotingConstants.DEFAULT_CHARSET));
            }
        }
        return response;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        byte[] body = this.getResponse();
        long id = this.getRequestID();
        int capacity = 20 + body.length;
        bytebufferWrapper.ensureCapacity(capacity);
        bytebufferWrapper.writeByte((byte)14);
        bytebufferWrapper.writeByte((byte)1);
        bytebufferWrapper.writeByte((byte)1);
        bytebufferWrapper.writeByte(this.getStatus().getCode());
        bytebufferWrapper.writeByte(this.getCodecType());
        bytebufferWrapper.writeBytes(EXTENED_BYTES);
        bytebufferWrapper.writeLong(id);
        bytebufferWrapper.writeInt(body.length);
        bytebufferWrapper.writeBytes(body);
    }

    @Override
    public int size() {
        return this.response == null ? 0 : this.response.length;
    }
}

