/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.ProtocolFactory;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.TbRemotingResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.TbRemotingProtocol;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import com.taobao.remoting.util.BytesUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TbRemotingRequest
extends BaseRequest {
    private static final ServerHandler<? extends BaseRequest> serverHandler = ProtocolFactory.instance.getServerHandler((byte)13);
    private final InputStream inputStream;
    private final SliceOutputStream sliceOS;
    private final byte codecType;
    private final int size;

    private TbRemotingRequest(InputStream is, long id, byte codecType, int timeout, SliceOutputStream sliceOS, int size) {
        super(13, id, timeout);
        this.inputStream = is;
        this.sliceOS = sliceOS;
        this.codecType = codecType;
        this.size = size;
    }

    public TbRemotingRequest(InputStream is, byte codecType, int size) {
        this(is, -1L, codecType, 3000, null, size);
    }

    public TbRemotingRequest(SliceOutputStream sliceOS, long id, byte codecType, int timeout) {
        this(null, id, codecType, timeout, sliceOS, sliceOS.size());
    }

    public InputStream getRequestInputStream() {
        if (this.inputStream == null) {
            throw new IllegalStateException("should never be here");
        }
        return this.inputStream;
    }

    public SliceOutputStream getSliceOs() {
        if (this.sliceOS == null) {
            throw new IllegalStateException("should never be here");
        }
        return this.sliceOS;
    }

    public byte getCodecType() {
        if (this.inputStream == null) {
            throw new IllegalStateException("should never be here");
        }
        return this.codecType;
    }

    @Override
    public BaseResponse createErrorResponse(String responseInfo) {
        if (this.inputStream == null) {
            return new TbRemotingResponse(responseInfo);
        }
        ConnectionRequest request = null;
        try {
            byte[] headers = new byte[14];
            this.inputStream.read(headers);
            int connLength = BytesUtil.bytes2int((byte[])headers, (int)5);
            byte[] connData = new byte[connLength];
            this.inputStream.read(connData);
            request = (ConnectionRequest)TbRemotingProtocol.defaultSerialize.deserialize((InputStream)new ByteArrayInputStream(connData), this.codecType);
        }
        catch (IOException ioe) {
            LoggerInit.LOGGER_REMOTING.error("", ioe.getMessage(), (Throwable)ioe);
            return null;
        }
        ConnectionResponse errorResponse = ConnectionResponse.getResponse((ConnectionRequest)request);
        HSFResponse response = new HSFResponse();
        response.setErrorMsg(responseInfo);
        errorResponse.setAppResponse((Object)response);
        SliceOutputStream os = new SliceOutputStream();
        try {
            RemotingConstants.CONN_RESPONSE_SERIALIZER.serialize(errorResponse, this.codecType, (OutputStream)os);
            return new TbRemotingResponse(os);
        }
        catch (IOException e1) {
            LoggerInit.LOGGER_REMOTING.error("", "[Remoting Error]", (Throwable)e1);
            return new TbRemotingResponse(os);
        }
    }

    @Override
    public ServerHandler<? extends BaseRequest> getServerHandler() {
        return serverHandler;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        SliceOutputStream os = this.getSliceOs();
        bytebufferWrapper.ensureCapacity(os.size());
        for (byte[] slice : os.allSlices()) {
            bytebufferWrapper.writeBytes(slice);
        }
    }

    @Override
    public int size() {
        return this.size;
    }
}

