/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.adaptor.dubbo;

import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Decodeable;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.util.HashMap;
import java.util.Map;

public class DecodeableRpcInvocation
extends RpcInvocation
implements Decodeable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGERE = LoggerInit.LOGGER_REMOTING;
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private byte serializationType;
    private InputStream inputStream;
    private volatile boolean hasDecoded;

    public DecodeableRpcInvocation(InputStream is, byte id) {
        this.inputStream = is;
        this.serializationType = id;
    }

    public void decode() throws Exception {
        if (!this.hasDecoded && this.inputStream != null) {
            try {
                this.decode(this.inputStream);
            }
            catch (Throwable e) {
                LOGGERE.warn("Decode rpc invocation failed: " + e.getMessage(), new Object[]{e});
                throw new Exception(e);
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object decode(InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerializationById((Byte)this.serializationType).deserialize(null, input);
        this.setAttachment("dubbo", in.readUTF());
        this.setAttachment("path", in.readUTF());
        this.setAttachment("version", in.readUTF());
        this.setMethodName(in.readUTF());
        try {
            Object[] args;
            Class[] pts;
            String desc = in.readUTF();
            if (desc.length() == 0) {
                pts = EMPTY_CLASS_ARRAY;
                args = EMPTY_OBJECT_ARRAY;
            } else {
                pts = ReflectUtils.desc2classArray((String)desc);
                args = new Object[pts.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = in.readObject(pts[i]);
                }
            }
            this.setParameterTypes(pts);
            Map map = (Map)in.readObject(Map.class);
            if (map != null && map.size() > 0) {
                HashMap attachment = this.getAttachments();
                if (attachment == null) {
                    attachment = new HashMap();
                }
                attachment.putAll(map);
                this.setAttachments(attachment);
            }
            this.setArguments(args);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(StringUtils.toString((String)"Read invocation data failed.", (Throwable)e));
        }
        return this;
    }
}

