/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.adaptor.dubbo;

import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Decodeable;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.RpcResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecodeableRpcResult
extends RpcResult
implements Decodeable {
    private static final long serialVersionUID = 1L;
    public static final byte RESPONSE_WITH_EXCEPTION = 0;
    public static final byte RESPONSE_VALUE = 1;
    public static final byte RESPONSE_NULL_VALUE = 2;
    private byte serializationType;
    private InputStream inputStream;

    public DecodeableRpcResult(InputStream is, byte id) {
        this.inputStream = is;
        this.serializationType = id;
    }

    public void encode(OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object decode(InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerializationById((Byte)this.serializationType).deserialize(null, input);
        byte flag = in.readByte();
        switch (flag) {
            case 2: {
                break;
            }
            case 1: {
                try {
                    this.setValue(in.readObject());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(StringUtils.toString((String)"Read response data failed.", (Throwable)e));
                }
            }
            case 0: {
                try {
                    Object obj = in.readObject();
                    if (!(obj instanceof Throwable)) {
                        throw new IOException("Response data error, expect Throwable, but get " + obj);
                    }
                    this.setException((Throwable)obj);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(StringUtils.toString((String)"Read response data failed.", (Throwable)e));
                }
            }
            default: {
                throw new IOException("Unknown result flag, expect '0' '1' '2', get " + flag);
            }
        }
        return this;
    }

    public void decode() throws IOException {
        if (this.inputStream != null) {
            this.decode(this.inputStream);
        }
    }
}

