/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.client;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.SendCallBackListener;
import com.taobao.middleware.logger.Logger;
import java.util.concurrent.ThreadPoolExecutor;

public final class HeartbeatListner
implements SendCallBackListener {
    private static final Logger LOGGER = LoggerInit.LOGGER_REMOTING;
    private final Client client;

    public HeartbeatListner(Client client) {
        this.client = client;
    }

    @Override
    public void onResponse(HSFResponse response) {
        if (response == null || response.isError()) {
            this.closeIfPossible();
        } else {
            this.client.resetHbTimes();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("heartbeat check successfully:" + this.client);
            }
        }
    }

    private void closeIfPossible() {
        if (this.client.inceaseAndGetHbTimes() > 2) {
            this.innerCloseConnection();
        }
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return null;
    }

    private void innerCloseConnection() {
        LOGGER.warn("##########heartbeat check failed:" + this.client);
        this.client.close("heartbeat failed for three times");
    }
}

