/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.client;

import com.ali.com.google.common.util.concurrent.AbstractFuture;
import com.taobao.eagleeye.EagleEye;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.client.BaseRequestWrapperInterface;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class RequestWrapperOfFuture
extends AbstractFuture<Object>
implements BaseRequestWrapperInterface {
    private final BaseRequest request;
    private final long startTime = System.currentTimeMillis();

    public static RequestWrapperOfFuture create(BaseRequest request) {
        return new RequestWrapperOfFuture(request);
    }

    private RequestWrapperOfFuture(BaseRequest request) {
        this.request = request;
    }

    public boolean set(Object value) {
        return super.set(value);
    }

    public boolean setException(Throwable throwable) {
        return super.setException(throwable);
    }

    public HSFResponse get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        BaseResponse response = (BaseResponse)super.get((long)this.request.getTimeout(), TimeUnit.MILLISECONDS);
        EagleEye.responseSize((long)response.size());
        return response.getResponseObject(this.request);
    }

    public HSFResponse get() throws InterruptedException, ExecutionException {
        try {
            BaseResponse response = (BaseResponse)super.get((long)this.request.getTimeout(), TimeUnit.MILLISECONDS);
            EagleEye.responseSize((long)response.size());
            return response.getResponseObject(this.request);
        }
        catch (TimeoutException e) {
            HSFResponse response = new HSFResponse();
            response.setClientErrorMsg("Timeout on client side, request ID: " + this.request.getRequestID());
            return response;
        }
    }

    @Override
    public BaseRequest getRequest() {
        return this.request;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void onResponse(BaseResponse response) {
        this.set(response);
    }

    @Override
    public void removeAllRequestCallBackWhenClose() {
        BaseResponse response = this.request.createErrorResponse("invalid call is removed because of connection closed");
        response.setStatus(ResponseStatus.COMM_ERROR);
        this.set(response);
    }

    @Override
    public void cleanupInvalidCallBack() {
        BaseResponse response = this.request.createErrorResponse("invalid call because of timeout:" + this.request.getTimeout());
        response.setStatus(ResponseStatus.CLIENT_TIMEOUT);
        this.set(response);
    }
}

