/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.exception;

import com.taobao.hsf.remoting.exception.ErrorCode;
import com.taobao.hsf.remoting.exception.ErrorCodeDataSource;
import com.taobao.hsf.util.HSFServiceContainer;
import java.util.List;

public final class ErrorCodeFactory {
    private static final ErrorCodeFactory instance = new ErrorCodeFactory();
    private final ErrorCodeDataSource dataSource = (ErrorCodeDataSource)HSFServiceContainer.getInstance(ErrorCodeDataSource.class);

    private ErrorCodeFactory() {
    }

    public static ErrorCodeFactory getInstance() {
        return instance;
    }

    public int size() {
        return this.dataSource.size();
    }

    public ErrorCode getErrorCode(int codeStr) {
        return this.dataSource.getCode(codeStr);
    }

    public List<ErrorCode> getErrorCodes() {
        return this.dataSource.getCodes();
    }

    public String getErrorCodeMessage(ErrorCode code) {
        if (code == null) {
            return null;
        }
        return code.getMessage();
    }
}

