/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.exception;

import com.taobao.hsf.remoting.exception.ErrorCode;
import com.taobao.hsf.remoting.exception.ErrorCodeFactory;

public class RemotingUncheckedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ErrorCode errorCode;
    private final String[] args;

    public RemotingUncheckedException(ErrorCode errorCode, Throwable e, String ... args) {
        super(e);
        this.errorCode = errorCode;
        this.args = args;
    }

    public RemotingUncheckedException(ErrorCode errorCode, String ... args) {
        this(errorCode, (Throwable)null, args);
    }

    public RemotingUncheckedException(int errorCode, Throwable e, String ... args) {
        this(ErrorCodeFactory.getInstance().getErrorCode(errorCode), e, args);
    }

    public RemotingUncheckedException(int errorCode, String ... args) {
        this(ErrorCodeFactory.getInstance().getErrorCode(errorCode), (Throwable)null, args);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.errorCode.getFormattedMessage(this.args);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getFormattedMessage();
    }

    public String getFormattedMessage() {
        return this.errorCode.getFormattedMessage(this.args);
    }
}

