/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.mbean;

import com.taobao.hsf.remoting.mbean.HSFMonitorMBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HSFMonitor
implements HSFMonitorMBean {
    private static final HSFMonitor INSTANCE = new HSFMonitor();
    private Map<String, AtomicLong> totalCount = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, Long> totalTime = new ConcurrentHashMap<String, Long>();
    private Map<String, AtomicInteger> threadCount = new ConcurrentHashMap<String, AtomicInteger>();

    private HSFMonitor() {
    }

    public static HSFMonitor getInstance() {
        return INSTANCE;
    }

    @Override
    public Map<String, AtomicLong> getTotalCount() {
        return this.totalCount;
    }

    @Override
    public void setTotalCount(Map<String, AtomicLong> totalCount) {
        this.totalCount = totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTotalCount(String uniqueServiceName) {
        AtomicLong serviceTotalCount = this.totalCount.get(uniqueServiceName);
        if (serviceTotalCount == null) {
            HSFMonitor hSFMonitor = this;
            synchronized (hSFMonitor) {
                serviceTotalCount = this.totalCount.get(uniqueServiceName);
                if (serviceTotalCount == null) {
                    serviceTotalCount = new AtomicLong(0L);
                    this.totalCount.put(uniqueServiceName, serviceTotalCount);
                }
            }
        }
        serviceTotalCount.incrementAndGet();
    }

    @Override
    public Map<String, Long> getTotalTime() {
        return this.totalTime;
    }

    public void changeTotalTime(String uniqueServiceName, long time) {
        this.totalTime.put(uniqueServiceName, time);
    }

    @Override
    public Map<String, AtomicInteger> getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setThreadCount(Map<String, AtomicInteger> threadCount) {
        this.threadCount = threadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementThreadCount(String uniqueServiceName) {
        AtomicInteger serviceThreadCount = this.threadCount.get(uniqueServiceName);
        if (serviceThreadCount == null) {
            HSFMonitor hSFMonitor = this;
            synchronized (hSFMonitor) {
                serviceThreadCount = this.threadCount.get(uniqueServiceName);
                if (serviceThreadCount == null) {
                    serviceThreadCount = new AtomicInteger(0);
                    this.threadCount.put(uniqueServiceName, serviceThreadCount);
                }
            }
        }
        serviceThreadCount.incrementAndGet();
    }

    public void decrementThreadCount(String uniqueServiceName) {
        AtomicInteger serviceThreadCount = this.threadCount.get(uniqueServiceName);
        if (serviceThreadCount != null) {
            serviceThreadCount.decrementAndGet();
        }
    }
}

