/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.pool;

import com.taobao.hsf.NamedThreadFactory;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.thread.HSFThreadNameSpace;
import com.taobao.hsf.util.JVMUtils;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private static final long keepAliveTime = 300L;
    private final RejectedExecutionHandler handler = new IgnoreRunsPolicy();
    private final ThreadPoolExecutor defaultPoolExecutor;
    private final Map<String, ThreadPoolExecutor> poolCache = new HashMap<String, ThreadPoolExecutor>();

    public ThreadPoolManager(int corePoolSize, int maximumPoolSize, int queueSize) {
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        NamedThreadFactory threadFactory = new NamedThreadFactory("HSFBizProcessor");
        this.defaultPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 300L, TimeUnit.SECONDS, workQueue, (ThreadFactory)threadFactory, this.handler);
    }

    public void allocThreadpool(String serviceUniqueName, int corePoolSize, int maximumPoolSize) throws HSFException {
        if (this.poolCache.containsKey(serviceUniqueName)) {
            throw new HSFException(MessageFormat.format("[ThreadPool Manager] Duplicated thread pool allocation request for service [{0}].", serviceUniqueName));
        }
        if (this.defaultPoolExecutor == null || this.defaultPoolExecutor.isShutdown()) {
            throw new HSFException(MessageFormat.format("[ThreadPool Manager] Can not allocate thread pool for service [{0}].", serviceUniqueName));
        }
        int balance = this.defaultPoolExecutor.getMaximumPoolSize();
        if (balance < maximumPoolSize) {
            throw new HSFException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0017", (String)"\u4e1a\u52a1\u95ee\u9898", (String)MessageFormat.format("[ThreadPool Manager] Thread pool allocated failed for service [{0}]: balance [{1}] require [{2}].", serviceUniqueName, balance, maximumPoolSize)));
        }
        NamedThreadFactory threadFactory = new NamedThreadFactory(HSFThreadNameSpace.getNettyProcessorService((String)serviceUniqueName));
        try {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory, this.handler);
            this.poolCache.put(serviceUniqueName, executor);
        }
        catch (Exception e) {
            throw new HSFException("[ThreadPool Manager] Thread pool allocated failed!", (Throwable)e);
        }
        int newBalance = balance - maximumPoolSize;
        if (newBalance == 0) {
            this.defaultPoolExecutor.shutdown();
        } else {
            if (newBalance < this.defaultPoolExecutor.getCorePoolSize()) {
                this.defaultPoolExecutor.setCorePoolSize(newBalance);
            }
            this.defaultPoolExecutor.setMaximumPoolSize(newBalance);
        }
    }

    public Executor getThreadExecutor(String serviceUniqueName) {
        ThreadPoolExecutor executor;
        if (!this.poolCache.isEmpty() && (executor = this.poolCache.get(serviceUniqueName)) != null) {
            return executor;
        }
        return this.defaultPoolExecutor;
    }

    public ThreadPoolExecutor getDefaultPoolExecutor() {
        return this.defaultPoolExecutor;
    }

    public void shutdown() {
        if (this.defaultPoolExecutor != null && !this.defaultPoolExecutor.isShutdown()) {
            this.defaultPoolExecutor.shutdown();
        }
        if (!this.poolCache.isEmpty()) {
            for (ThreadPoolExecutor poolExecutor : this.poolCache.values()) {
                poolExecutor.shutdown();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\u5f53\u524d\u7ebf\u7a0b\u6c60\u5206\u914d\u7b56\u7565\uff1a");
        for (Map.Entry<String, ThreadPoolExecutor> entry : this.poolCache.entrySet()) {
            String serviceUniqName = entry.getKey();
            ThreadPoolExecutor executor = entry.getValue();
            sb.append("\u670d\u52a1[" + serviceUniqName + "]\u6838\u5fc3\u7ebf\u7a0b\u6570\u91cf\uff1a" + executor.getCorePoolSize() + " \u6700\u5927\u7ebf\u7a0b\u6570\u91cf\uff1a" + executor.getMaximumPoolSize() + " \u6d3b\u52a8\u7ebf\u7a0b\u6570\u91cf\uff1a" + executor.getActiveCount());
        }
        if (!this.defaultPoolExecutor.isShutdown()) {
            sb.append("\u670d\u52a1\u9ed8\u8ba4\u4f7f\u7528\u7684\u6838\u5fc3\u7ebf\u7a0b\u6570\u91cf\uff1a" + this.defaultPoolExecutor.getCorePoolSize() + " \u6700\u5927\u7ebf\u7a0b\u6570\u91cf\uff1a " + this.defaultPoolExecutor.getMaximumPoolSize() + " \u6d3b\u52a8\u7ebf\u7a0b\u6570\u91cf\uff1a" + this.defaultPoolExecutor.getActiveCount());
        }
        return sb.toString();
    }

    private static class IgnoreRunsPolicy
    implements RejectedExecutionHandler {
        private static final Logger LOGGER = LoggerInit.LOGGER_REMOTING;
        public volatile boolean hasDump = false;

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            this.dumpJVMInfo();
            throw new RejectedExecutionException();
        }

        private void dumpJVMInfo() {
            if (!this.hasDump) {
                this.hasDump = true;
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String logPath = System.getProperty("HSF.LOG.PATH");
                        FileOutputStream jstackStream = null;
                        try {
                            boolean needDump;
                            jstackStream = new FileOutputStream(new File(logPath, "HSF_JStack.log"));
                            JVMUtils.jstack((OutputStream)jstackStream);
                            String dumpHeapAnyway = System.getProperty("hsf.dumpheap.force", "n");
                            boolean bl = needDump = "y".equals(dumpHeapAnyway) || JVMUtils.memoryUsed((OutputStream)jstackStream) > 0.9;
                            if (needDump) {
                                if (logPath == null || logPath.isEmpty()) {
                                    JVMUtils.jMap((String)"HSF_JMap.bin", (boolean)false);
                                } else {
                                    JVMUtils.jMap((String)(logPath + File.separator + "HSF_JMap.bin"), (boolean)false);
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("", "Dump JVM cache Error!", (Throwable)e);
                        }
                        catch (Throwable t) {
                            LOGGER.error("", "Dump JVM cache Error!", t);
                        }
                        finally {
                            if (jstackStream != null) {
                                try {
                                    jstackStream.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                });
            }
        }
    }
}

