/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.protocol;

import com.taobao.hsf.remoting.Dubbo2Request;
import com.taobao.hsf.remoting.Dubbo2Response;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.Protocol;
import com.taobao.hsf.remoting.util.BytesUtil;

public class DubboProtocol
implements Protocol {
    public static final int HEADER_LENGTH = 16;
    public static final short MAGIC = -9541;
    public static final byte MAGIC_HIGH = BytesUtil.short2bytes((short)-9541)[0];
    public static final byte MAGIC_LOW = BytesUtil.short2bytes((short)-9541)[1];
    public static final byte FLAG_REQUEST = -128;
    public static final byte FLAG_TWOWAY = 64;
    public static final byte FLAG_EVENT = 32;
    public static final int SERIALIZATION_MASK = 31;
    public static final String DUBBO_VERSION = "HSF2.0";

    @Override
    public Object decode(ByteBufferWrapper wrapper, int originPos) throws Exception {
        if (wrapper.readableBytes() < 15) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte[] header = new byte[15];
        wrapper.readBytes(header);
        int len = BytesUtil.bytes2int(header, 11);
        if (wrapper.readableBytes() < len) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte[] body = new byte[len];
        wrapper.readBytes(body);
        byte flag = header[1];
        byte codecType = (byte)(flag & 0x1F);
        long id = BytesUtil.bytes2long(header, 3);
        if ((flag & 0xFFFFFF80) == 0) {
            byte status = header[2];
            Dubbo2Response response = new Dubbo2Response(id, DUBBO_VERSION, body, codecType);
            response.setStatus(status);
            return response;
        }
        if ((flag & 0x20) != 0) {
            Dubbo2Response res = new Dubbo2Response(id, DUBBO_VERSION, null, 2);
            res.setEvent(RemotingConstants.DUBBO2_HEARTBEAT_BODY);
            wrapper.send(res);
            return null;
        }
        Dubbo2Request request = new Dubbo2Request(id, DUBBO_VERSION, body, codecType);
        request.setTwoway((flag & 0x40) != 0);
        return request;
    }
}

