/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.serialize;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.SerializerFactory;
import com.taobao.hsf.remoting.serialize.Decoder;
import com.taobao.hsf.remoting.serialize.Encoder;
import com.taobao.hsf.remoting.serialize.FastJsonDecoder;
import com.taobao.hsf.remoting.serialize.FastJsonEncoder;
import com.taobao.hsf.remoting.serialize.Hessian2Decoder;
import com.taobao.hsf.remoting.serialize.Hessian2Encoder;
import com.taobao.hsf.remoting.serialize.HessianDecoder;
import com.taobao.hsf.remoting.serialize.HessianEncoder;
import com.taobao.hsf.remoting.serialize.JavaDecoder;
import com.taobao.hsf.remoting.serialize.JavaEncoder;
import com.taobao.hsf.remoting.serialize.KryoDecoder;
import com.taobao.hsf.remoting.serialize.KryoEncoder;
import com.taobao.remoting.serialize.impl.hessian.AliEnumSerializerFactory;

public class Codecs {
    public static final byte JAVA_CODEC = 2;
    public static final byte HESSIAN_CODEC = 1;
    public static final byte TOP_CODEC = 3;
    public static final byte HESSIAN2_CODEC = 4;
    public static final byte KRYO_CODEC = 5;
    public static final byte JSON_CODEC = 6;
    public static final byte CUSTOMIZED_CODEC = 7;
    public static final Encoder REQUESTPROP_ENCODER;
    public static final Decoder REQUESTPROP_DECODER;
    private static Encoder[] encoders;
    private static Decoder[] decoders;
    private static com.taobao.hsf.com.caucho.hessian.io.SerializerFactory factory;
    private static SerializerFactory serializerFactory;

    public static void addEncoder(int encoderKey, Encoder encoder) {
        if (encoderKey > encoders.length) {
            Encoder[] newEncoders = new Encoder[encoderKey + 1];
            System.arraycopy(encoders, 0, newEncoders, 0, encoders.length);
            encoders = newEncoders;
        }
        Codecs.encoders[encoderKey] = encoder;
    }

    public static void addDecoder(int decoderKey, Decoder decoder) {
        if (decoderKey > decoders.length) {
            Decoder[] newDecoders = new Decoder[decoderKey + 1];
            System.arraycopy(decoders, 0, newDecoders, 0, decoders.length);
            decoders = newDecoders;
        }
        Codecs.decoders[decoderKey] = decoder;
    }

    public static Encoder getEncoder(int encoderKey) {
        return encoders[encoderKey];
    }

    public static Decoder getDecoder(int decoderKey) {
        return decoders[decoderKey];
    }

    public static SerializerFactory getHessianSerializerFactory() {
        return serializerFactory;
    }

    static {
        encoders = new Encoder[7];
        decoders = new Decoder[7];
        serializerFactory = new SerializerFactory();
        serializerFactory.addFactory((AbstractSerializerFactory)new AliEnumSerializerFactory());
        factory = new com.taobao.hsf.com.caucho.hessian.io.SerializerFactory(Codecs.class.getClassLoader());
        factory.setAllowNonSerializable(true);
        Codecs.addEncoder(1, new HessianEncoder(serializerFactory));
        Codecs.addEncoder(2, new JavaEncoder());
        Codecs.addEncoder(3, new JavaEncoder());
        REQUESTPROP_ENCODER = new Hessian2Encoder(factory);
        Codecs.addEncoder(4, REQUESTPROP_ENCODER);
        Codecs.addEncoder(5, new KryoEncoder());
        Codecs.addEncoder(6, new FastJsonEncoder());
        Codecs.addDecoder(2, new JavaDecoder());
        Codecs.addDecoder(1, new HessianDecoder(serializerFactory));
        Codecs.addDecoder(3, new JavaDecoder());
        REQUESTPROP_DECODER = new Hessian2Decoder(factory);
        Codecs.addDecoder(4, REQUESTPROP_DECODER);
        Codecs.addDecoder(5, new KryoDecoder());
        Codecs.addDecoder(6, new FastJsonDecoder());
    }
}

