/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.server;

import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.RpcContext;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.Dubbo2Request;
import com.taobao.hsf.remoting.Dubbo2Response;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.adaptor.dubbo.DecodeableRpcInvocation;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.hsf.remoting.server.output.DubboRemotingOutput;
import com.taobao.hsf.remoting.util.DIYExecutor;
import com.taobao.hsf.remoting.util.RemotingUtil;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboRemotingHandler
implements ServerHandler<Dubbo2Request> {
    private static final Logger LOGGER = LoggerInit.LOGGER_REMOTING;
    public static final byte RESPONSE_WITH_EXCEPTION = 0;
    public static final byte RESPONSE_VALUE = 1;
    public static final byte RESPONSE_NULL_VALUE = 2;
    private final ThreadPoolExecutor defaultPoolExecutor;
    private final RpcRequestProcessor rpcRequestProcessor;

    public DubboRemotingHandler(RpcRequestProcessor rpcRequestProcessor) {
        this.rpcRequestProcessor = rpcRequestProcessor;
        this.defaultPoolExecutor = rpcRequestProcessor.getThreadPoolManager().getDefaultPoolExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(Dubbo2Request request, Connection connection, long startTime) {
        if (request.isHeartbeat()) {
            if (request.isTwoway()) {
                Dubbo2Response res = new Dubbo2Response(request.getRequestID(), request.getVersion(), null, request.getCodecType());
                res.setEvent(Dubbo2Response.HEARTBEAT_EVENT);
                connection.writeReponseToChannel(res);
            }
        } else {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(request.getData());
                DecodeableRpcInvocation inv = new DecodeableRpcInvocation(is, request.getCodecType());
                inv.decode();
                HashMap attachments = inv.getAttachments();
                if (attachments != null) {
                    attachments = new HashMap(attachments);
                    attachments.remove("path");
                    attachments.remove("group");
                    attachments.remove("version");
                    attachments.remove("dubbo");
                    attachments.remove("token");
                    attachments.remove("timeout");
                    attachments.remove("async");
                }
                RpcContext.getContext().setAttachments((Map)attachments).setProviderSide(true).setLocalAddress((InetSocketAddress)connection.getLocalAddress()).setRemoteAddress((InetSocketAddress)connection.getRemoteAddress());
                RpcContext.getContext().setMethodName(inv.getMethodName());
                RpcContext.getContext().setParameterTypes(inv.getParameterTypes());
                RpcContext.getContext().setArguments(inv.getArguments());
                DubboRemotingOutput output = new DubboRemotingOutput(connection, request, startTime);
                this.rpcRequestProcessor.handleRequest(RemotingUtil.convert(inv), output);
            }
            catch (Exception e) {
                LOGGER.warn("server handle request error", new Object[]{e});
                long requestId = request.getRequestID();
                String version = request.getVersion();
                byte codeType = request.getCodecType();
                try {
                    UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
                    ObjectOutput objectOutput = CodecSupport.getSerializationById((Byte)codeType).serialize(null, (OutputStream)os);
                    if (objectOutput != null) {
                        objectOutput.writeByte((byte)0);
                        objectOutput.writeObject((Object)e);
                        objectOutput.flushBuffer();
                    }
                    Dubbo2Response response = new Dubbo2Response(requestId, version, os.toByteArray(), codeType);
                    response.setStatus(ResponseStatus.SERVER_ERROR);
                    connection.writeReponseToChannel(response);
                }
                catch (Exception e1) {
                    Dubbo2Response response = new Dubbo2Response(requestId, version, null, codeType);
                    response.setStatus(ResponseStatus.UNKNOW_CODE);
                    connection.writeReponseToChannel(response);
                }
            }
            finally {
                RpcContext.removeContext();
            }
        }
    }

    @Override
    public Executor getExecutor(Dubbo2Request request) {
        if (request.isHeartbeat()) {
            return DIYExecutor.getInstance();
        }
        return this.defaultPoolExecutor;
    }
}

