/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.server;

import com.alibaba.dubbo.rpc.RpcContext;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.RpcRequest;
import com.taobao.hsf.remoting.RpcResponse;
import com.taobao.hsf.remoting.pool.ThreadPoolManager;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.hsf.remoting.server.output.RpcOutput;
import com.taobao.hsf.remoting.util.RemotingUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.util.Date;
import java.util.concurrent.Executor;

public class RPCServerHandler
implements ServerHandler<RpcRequest> {
    private static final Logger LOGGER = LoggerInit.LOGGER_REMOTING;
    private final RpcRequestProcessor rpcRequestProcessor;
    private final ThreadPoolManager threadPoolManager;

    public RPCServerHandler(RpcRequestProcessor rpcRequestProcessor) {
        this.rpcRequestProcessor = rpcRequestProcessor;
        this.threadPoolManager = rpcRequestProcessor.getThreadPoolManager();
    }

    public void registerProcessor(String instanceName, Object instance) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(RpcRequest request, Connection connection, long startTime) {
        try {
            RpcOutput output = new RpcOutput(connection, request, startTime);
            this.rpcRequestProcessor.handleRequest(RemotingUtil.convert(request), output);
        }
        catch (Throwable t) {
            LOGGER.error("", "[Provider Error]:" + connection, t);
            byte[] reponseException = LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0032", (String)"\u4e1a\u52a1\u95ee\u9898", (String)("please check log on server side that unknown server error happens @" + new Date() + ",on connection:" + connection)).getBytes(RemotingConstants.DEFAULT_CHARSET);
            connection.writeReponseToChannel(new RpcResponse(request.getRequestID(), request.getCodecType(), ResponseStatus.SERVER_ERROR, reponseException));
        }
        finally {
            RpcContext.getContext().clearAttachments();
        }
    }

    @Override
    public Executor getExecutor(RpcRequest rpcRequest) {
        return this.threadPoolManager.getThreadExecutor(rpcRequest.getTargetInstanceName());
    }
}

